# SEO Execution Strategy Reporting App

A production-ready Flask application for managing SEO strategies, tracking performance via GA4/GSC, and generating PowerPoint reports.

## Features
- **Strategy Management**: Define hypotheses, owners, and timelines.
- **Data Integration**: Connects to Google Analytics 4 and Google Search Console.
- **Interactive Wizard**: Step-by-step setup for new case studies.
- **Reporting**: Automatic generation of PPTX decks with Matplotlib charts.
- **Background Jobs**: Celery + Redis for async data fetching and report generation.

## Prerequisities
- Python 3.11+
- Redis Server
- MySQL (Production) or SQLite (Dev)

## Setup

1. **Install Dependencies**
   ```bash
   python3 -m venv venv
   source venv/bin/activate
   pip install -r requirements.txt
   ```

2. **Configuration**
   Copy `.env.example` to `.env` and fill in your details.
   ```bash
   cp .env.example .env
   ```
   *Note: For Google OAuth, you need to create credentials in Google Cloud Console and add `http://localhost:5000` (or your domain) to Authorized Redirect URIs.*

3. **Initialize Database**
   ```bash
   export FLASK_APP=wsgi.py
   flask db init
   flask db migrate -m "Initial migration"
   flask db upgrade
   ```

4. **Run Locally**
   Start Redis:
   ```bash
   redis-server
   ```
   
   Start Celery Worker:
   ```bash
   celery -A app.celery worker --loglevel=info
   ```
   
   Start Flask App:
   ```bash
   flask run
   ```

## Deployment
See `deploy/` directory for systemd services and Apache configuration.

1. **Set up Apache**
   Copy `deploy/apache-vhost.conf` to `/etc/apache2/sites-available/` and enable it.
   Enable proxy modules: `a2enmod proxy proxy_http`.

2. **Set up Gunicorn**
   Copy `deploy/gunicorn.service` to `/etc/systemd/system/`.

3. **Set up Celery**
   Copy `deploy/celery.service` to `/etc/systemd/system/`.

## Tests
Run the pytest suite:
```bash
pytest
```
