from flask import Blueprint, render_template
from flask_login import login_required, current_user
from app.models import Strategy, Report, MetricSnapshot, CaseStudy

dashboard_bp = Blueprint('dashboard', __name__)

@dashboard_bp.route('/')
@login_required
def index():
    strategies = current_user.strategies.order_by(Strategy.created_at.desc()).limit(10).all()
    
    stats = {
        'active_strategies': current_user.strategies.count(),
        # Use a join or simpler query if needed, relying on relationships
        'total_reports': Report.query.join(Report.case_study).join(CaseStudy.strategy).filter(Strategy.user_id==current_user.id).count(),
        'data_points': MetricSnapshot.query.join(MetricSnapshot.case_study).join(CaseStudy.strategy).filter(Strategy.user_id==current_user.id).count()
    }
    
    return render_template('dashboard/index.html', strategies=strategies, stats=stats)
