from datetime import datetime
from app import db

class MetricSnapshot(db.Model):
    __tablename__ = 'metric_snapshots'
    
    id = db.Column(db.Integer, primary_key=True)
    case_study_id = db.Column(db.Integer, db.ForeignKey('case_studies.id'))
    source = db.Column(db.String(50))
    dimensions = db.Column(db.JSON)
    metrics = db.Column(db.JSON)
    date_start = db.Column(db.Date)
    date_end = db.Column(db.Date)
    pulled_at = db.Column(db.DateTime, default=datetime.utcnow)

class Upload(db.Model):
    __tablename__ = 'uploads'
    
    id = db.Column(db.Integer, primary_key=True)
    case_study_id = db.Column(db.Integer, db.ForeignKey('case_studies.id'))
    file_path = db.Column(db.String(255))
    original_filename = db.Column(db.String(255))
    mapping_config = db.Column(db.JSON)
    annotations = db.Column(db.JSON)
    created_at = db.Column(db.DateTime, default=datetime.utcnow)
    
    rows = db.relationship('UploadRow', backref='upload', lazy='dynamic')

class UploadRow(db.Model):
    __tablename__ = 'upload_rows'
    
    id = db.Column(db.Integer, primary_key=True)
    upload_id = db.Column(db.Integer, db.ForeignKey('uploads.id'))
    data = db.Column(db.JSON) # Normalized data

class Report(db.Model):
    __tablename__ = 'reports'
    
    id = db.Column(db.Integer, primary_key=True)
    case_study_id = db.Column(db.Integer, db.ForeignKey('case_studies.id'))
    pptx_path = db.Column(db.String(255))
    parameters = db.Column(db.JSON)
    status = db.Column(db.String(20)) # queued, processing, completed, failed
    error = db.Column(db.Text)
    created_at = db.Column(db.DateTime, default=datetime.utcnow)
