from datetime import datetime
from app import db

class Strategy(db.Model):
    __tablename__ = 'strategies'
    
    id = db.Column(db.Integer, primary_key=True)
    user_id = db.Column(db.Integer, db.ForeignKey('users.id'))
    name = db.Column(db.String(255), nullable=False)
    hypothesis = db.Column(db.Text)
    implementation_notes = db.Column(db.Text)
    owners = db.Column(db.String(255))
    tags = db.Column(db.String(255))
    created_at = db.Column(db.DateTime, default=datetime.utcnow)
    
    case_studies = db.relationship('CaseStudy', backref='strategy', lazy='dynamic')

class CaseStudy(db.Model):
    __tablename__ = 'case_studies'
    
    id = db.Column(db.Integer, primary_key=True)
    strategy_id = db.Column(db.Integer, db.ForeignKey('strategies.id'))
    
    ga4_property_id = db.Column(db.String(50))
    gsc_site_url = db.Column(db.String(255))
    
    benchmark_start_date = db.Column(db.Date)
    benchmark_end_date = db.Column(db.Date)
    post_start_date = db.Column(db.Date)
    post_end_date = db.Column(db.Date)
    
    status = db.Column(db.String(20), default='draft') # draft, active, archived
    
    kpis = db.relationship('KPI', backref='case_study', lazy='dynamic')
    snapshots = db.relationship('MetricSnapshot', backref='case_study', lazy='dynamic')
    uploads = db.relationship('Upload', backref='case_study', lazy='dynamic')
    reports = db.relationship('Report', backref='case_study', lazy='dynamic')

class KPI(db.Model):
    __tablename__ = 'kpis'
    
    id = db.Column(db.Integer, primary_key=True)
    case_study_id = db.Column(db.Integer, db.ForeignKey('case_studies.id'))
    source = db.Column(db.String(50)) # ga4, gsc, manual
    metric = db.Column(db.String(50)) # sessions, clicks, etc.
    config = db.Column(db.JSON) # filters, specific config

class StrategyActivityLog(db.Model):
    """Track activity/edits on strategies"""
    __tablename__ = 'strategy_activity_logs'
    
    id = db.Column(db.Integer, primary_key=True)
    strategy_id = db.Column(db.Integer, db.ForeignKey('strategies.id'), nullable=False)
    action = db.Column(db.String(50), nullable=False)  # edit, create, status_change, etc.
    details = db.Column(db.Text)  # Description of changes made
    user_email = db.Column(db.String(120))  # Who made the change
    created_at = db.Column(db.DateTime, default=datetime.utcnow)
    
    strategy = db.relationship('Strategy', backref=db.backref('activity_logs', lazy='dynamic'))

