from cryptography.fernet import Fernet
from flask import current_app

class CryptoService:
    def __init__(self):
        self.key = current_app.config.get('ENCRYPTION_KEY')
        if not self.key:
            # Fallback for dev only - in prod this should fail
            self.key = Fernet.generate_key()
        self.cipher = Fernet(self.key)

    def encrypt(self, data: str) -> bytes:
        return self.cipher.encrypt(data.encode())

    def decrypt(self, token: bytes) -> str:
        return self.cipher.decrypt(token).decode()
