from pptx import Presentation
from pptx.util import Inches, Pt
from pptx.enum.text import PP_ALIGN
from pptx.dml.color import RGBColor
import matplotlib.pyplot as plt
import io
import os
from datetime import datetime

class PPTXGenerator:
    def __init__(self, upload_folder):
        self.upload_folder = upload_folder

    def generate(self, case_study, data, filename):
        prs = Presentation()
        
        # 1. Title Slide
        slide_layout = prs.slide_layouts[0]
        slide = prs.slides.add_slide(slide_layout)
        title = slide.shapes.title
        subtitle = slide.placeholders[1]
        
        title.text = case_study.strategy.name
        subtitle.text = f"SEO Execution Report\nGenerated: {datetime.now().strftime('%B %d, %Y')}"
        
        # Apply Branding colors if available (Simplified)
        if case_study.strategy.user.primary_color:
             # Logic to convert hex to RGBColor would go here
             pass

        # 2. Executive Summary
        slide_layout = prs.slide_layouts[1]
        slide = prs.slides.add_slide(slide_layout)
        title = slide.shapes.title
        title.text = "Executive Summary"
        
        body = slide.placeholders[1]
        tf = body.text_frame
        tf.text = case_study.strategy.hypothesis
        p = tf.add_paragraph()
        p.text = "Benchmark: " + str(case_study.benchmark_start_date) + " - " + str(case_study.benchmark_end_date)
        p = tf.add_paragraph()
        p.text = "Post Period: " + str(case_study.post_start_date) + " - " + str(case_study.post_end_date)

        # 3. Chart Generation (Mocked Data for Demo)
        image_stream = self._create_mock_chart()
        
        slide_layout = prs.slide_layouts[5] # Blank
        slide = prs.slides.add_slide(slide_layout)
        title = slide.shapes.title
        title.text = "Traffic Performance"
        
        slide.shapes.add_picture(image_stream, Inches(1), Inches(2), width=Inches(8))
        
        # Save
        full_path = os.path.join(self.upload_folder, 'reports', filename)
        os.makedirs(os.path.dirname(full_path), exist_ok=True)
        prs.save(full_path)
        return full_path

    def _create_mock_chart(self):
        plt.figure(figsize=(10, 6))
        plt.plot([1, 2, 3, 4], [10, 20, 25, 30], label='Clicks', color='#0d6efd')
        plt.plot([1, 2, 3, 4], [5, 15, 20, 25], label='Impressions (x100)', color='#6c757d')
        plt.title('Performance Over Time')
        plt.legend()
        plt.grid(True, alpha=0.3)
        
        img_data = io.BytesIO()
        plt.savefig(img_data, format='png')
        img_data.seek(0)
        plt.close()
        return img_data
