import pandas as pd
import os
from werkzeug.utils import secure_filename
from app import db
from app.models import Upload, UploadRow

class UploadService:
    def __init__(self, upload_folder):
        self.upload_folder = upload_folder

    def process_upload(self, file_storage, case_study_id, mapping_config):
        filename = secure_filename(file_storage.filename)
        path = os.path.join(self.upload_folder, 'data', filename)
        os.makedirs(os.path.dirname(path), exist_ok=True)
        file_storage.save(path)
        
        # Create Upload Record
        upload = Upload(
            case_study_id=case_study_id,
            file_path=path,
            original_filename=filename,
            mapping_config=mapping_config
        )
        db.session.add(upload)
        db.session.commit()
        
        # Parse Data (Async in real production for large files)
        try:
            if filename.endswith('.csv'):
                df = pd.read_csv(path)
            else:
                df = pd.read_excel(path)
            
            # Normalize based on mapping...
            # For now, just dump rows
            
            rows = []
            for _, row in df.iterrows():
                rows.append(UploadRow(upload_id=upload.id, data=row.to_dict()))
            
            db.session.bulk_save_objects(rows)
            db.session.commit()
            return True
        except Exception as e:
            # maintain log
            return False
