"""Initial migration

Revision ID: 3ec4256ced73
Revises: 
Create Date: 2026-01-09 14:21:41.321410

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '3ec4256ced73'
down_revision = None
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('users',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('email', sa.String(length=120), nullable=True),
    sa.Column('password_hash', sa.String(length=256), nullable=True),
    sa.Column('company_name', sa.String(length=128), nullable=True),
    sa.Column('logo_path', sa.String(length=256), nullable=True),
    sa.Column('primary_color', sa.String(length=7), nullable=True),
    sa.Column('secondary_color', sa.String(length=7), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    with op.batch_alter_table('users', schema=None) as batch_op:
        batch_op.create_index(batch_op.f('ix_users_email'), ['email'], unique=True)

    op.create_table('oauth_tokens',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('user_id', sa.Integer(), nullable=True),
    sa.Column('provider', sa.String(length=50), nullable=True),
    sa.Column('token_blob', sa.LargeBinary(), nullable=True),
    sa.Column('expires_at', sa.DateTime(), nullable=True),
    sa.Column('scope', sa.Text(), nullable=True),
    sa.Column('created_at', sa.DateTime(), nullable=True),
    sa.ForeignKeyConstraint(['user_id'], ['users.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('strategies',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('user_id', sa.Integer(), nullable=True),
    sa.Column('name', sa.String(length=255), nullable=False),
    sa.Column('hypothesis', sa.Text(), nullable=True),
    sa.Column('implementation_notes', sa.Text(), nullable=True),
    sa.Column('owners', sa.String(length=255), nullable=True),
    sa.Column('tags', sa.String(length=255), nullable=True),
    sa.Column('created_at', sa.DateTime(), nullable=True),
    sa.ForeignKeyConstraint(['user_id'], ['users.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('case_studies',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('strategy_id', sa.Integer(), nullable=True),
    sa.Column('ga4_property_id', sa.String(length=50), nullable=True),
    sa.Column('gsc_site_url', sa.String(length=255), nullable=True),
    sa.Column('benchmark_start_date', sa.Date(), nullable=True),
    sa.Column('benchmark_end_date', sa.Date(), nullable=True),
    sa.Column('post_start_date', sa.Date(), nullable=True),
    sa.Column('post_end_date', sa.Date(), nullable=True),
    sa.Column('status', sa.String(length=20), nullable=True),
    sa.ForeignKeyConstraint(['strategy_id'], ['strategies.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('kpis',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('case_study_id', sa.Integer(), nullable=True),
    sa.Column('source', sa.String(length=50), nullable=True),
    sa.Column('metric', sa.String(length=50), nullable=True),
    sa.Column('config', sa.JSON(), nullable=True),
    sa.ForeignKeyConstraint(['case_study_id'], ['case_studies.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('metric_snapshots',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('case_study_id', sa.Integer(), nullable=True),
    sa.Column('source', sa.String(length=50), nullable=True),
    sa.Column('dimensions', sa.JSON(), nullable=True),
    sa.Column('metrics', sa.JSON(), nullable=True),
    sa.Column('date_start', sa.Date(), nullable=True),
    sa.Column('date_end', sa.Date(), nullable=True),
    sa.Column('pulled_at', sa.DateTime(), nullable=True),
    sa.ForeignKeyConstraint(['case_study_id'], ['case_studies.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('reports',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('case_study_id', sa.Integer(), nullable=True),
    sa.Column('pptx_path', sa.String(length=255), nullable=True),
    sa.Column('parameters', sa.JSON(), nullable=True),
    sa.Column('status', sa.String(length=20), nullable=True),
    sa.Column('error', sa.Text(), nullable=True),
    sa.Column('created_at', sa.DateTime(), nullable=True),
    sa.ForeignKeyConstraint(['case_study_id'], ['case_studies.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('uploads',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('case_study_id', sa.Integer(), nullable=True),
    sa.Column('file_path', sa.String(length=255), nullable=True),
    sa.Column('original_filename', sa.String(length=255), nullable=True),
    sa.Column('mapping_config', sa.JSON(), nullable=True),
    sa.Column('annotations', sa.JSON(), nullable=True),
    sa.Column('created_at', sa.DateTime(), nullable=True),
    sa.ForeignKeyConstraint(['case_study_id'], ['case_studies.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('upload_rows',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('upload_id', sa.Integer(), nullable=True),
    sa.Column('data', sa.JSON(), nullable=True),
    sa.ForeignKeyConstraint(['upload_id'], ['uploads.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('upload_rows')
    op.drop_table('uploads')
    op.drop_table('reports')
    op.drop_table('metric_snapshots')
    op.drop_table('kpis')
    op.drop_table('case_studies')
    op.drop_table('strategies')
    op.drop_table('oauth_tokens')
    with op.batch_alter_table('users', schema=None) as batch_op:
        batch_op.drop_index(batch_op.f('ix_users_email'))

    op.drop_table('users')
    # ### end Alembic commands ###
