from app.models import User, Strategy
from app import db

def test_config(app):
    assert not app.config['SECRET_KEY'] == 'dev-secret-key-change-in-prod' # Should be overridden or default
    assert app.config['TESTING']

def test_user_creation(app):
    with app.app_context():
        u = User(email='test@example.com', company_name='Test Corp')
        u.set_password('password')
        db.session.add(u)
        db.session.commit()
        
        fetched = User.query.filter_by(email='test@example.com').first()
        assert fetched is not None
        assert fetched.check_password('password')

def test_strategy_lifecycle(app):
    with app.app_context():
        u = User(email='test2@example.com')
        db.session.add(u)
        db.session.commit()
        
        s = Strategy(name='Q1 SEO', user=u)
        db.session.add(s)
        db.session.commit()
        
        assert s.id is not None
        assert s.user.email == 'test2@example.com'
