from app.models import User, Strategy, CaseStudy, Report
from app import db

def test_login_and_dashboard(client, app):
    # Create user
    with app.app_context():
        u = User(email='test@example.com', company_name='Test Corp')
        u.set_password('password')
        db.session.add(u)
        db.session.commit()

    # Login
    response = client.post('/auth/login', data={
        'email': 'test@example.com',
        'password': 'password'
    }, follow_redirects=True)
    assert response.status_code == 200
    assert b'Dashboard' in response.data

    # Check Dashboard Stats logic (empty)
    response = client.get('/')
    assert response.status_code == 200

def test_dashboard_with_data(client, app):
    with app.app_context():
        u = User(email='data@example.com')
        u.set_password('password')
        db.session.add(u)
        
        s = Strategy(user=u, name="Strat 1")
        db.session.add(s)
        
        cs = CaseStudy(strategy=s)
        db.session.add(cs)
        
        r = Report(case_study=cs, status='completed')
        db.session.add(r)
        
        db.session.commit()
    
    # Login
    client.post('/auth/login', data={'email': 'data@example.com', 'password': 'password'}, follow_redirects=True)
    
    response = client.get('/')
    assert response.status_code == 200
    # Assuming stats are rendered somewhere in HTML
    # Warning: templating might hide exact numbers, but checking 200 OK confirms no 500 error on join
