export { AsyncMotionValueAnimation } from './animation/AsyncMotionValueAnimation.mjs';
export { GroupAnimation } from './animation/GroupAnimation.mjs';
export { GroupAnimationWithThen } from './animation/GroupAnimationWithThen.mjs';
export { JSAnimation, animateValue } from './animation/JSAnimation.mjs';
export { NativeAnimation } from './animation/NativeAnimation.mjs';
export { NativeAnimationExtended } from './animation/NativeAnimationExtended.mjs';
export { NativeAnimationWrapper } from './animation/NativeAnimationWrapper.mjs';
export { animationMapKey, getAnimationMap } from './animation/utils/active-animations.mjs';
export { getVariableValue, parseCSSVariable } from './animation/utils/css-variables-conversion.mjs';
export { getValueTransition } from './animation/utils/get-value-transition.mjs';
export { containsCSSVariable, isCSSVariableName, isCSSVariableToken } from './animation/utils/is-css-variable.mjs';
export { makeAnimationInstant } from './animation/utils/make-animation-instant.mjs';
export { getDefaultTransition } from './animation/utils/default-transitions.mjs';
export { isTransitionDefined } from './animation/utils/is-transition-defined.mjs';
export { getFinalKeyframe } from './animation/utils/get-final-keyframe.mjs';
export { calcChildStagger } from './animation/utils/calc-child-stagger.mjs';
export { animateMotionValue } from './animation/interfaces/motion-value.mjs';
export { animateTarget } from './animation/interfaces/visual-element-target.mjs';
export { animateVariant } from './animation/interfaces/visual-element-variant.mjs';
export { animateVisualElement } from './animation/interfaces/visual-element.mjs';
export { optimizedAppearDataAttribute, optimizedAppearDataId } from './animation/optimized-appear/data-id.mjs';
export { getOptimisedAppearId } from './animation/optimized-appear/get-appear-id.mjs';
export { inertia } from './animation/generators/inertia.mjs';
export { defaultEasing, keyframes } from './animation/generators/keyframes.mjs';
export { spring } from './animation/generators/spring/index.mjs';
export { calcGeneratorDuration, maxGeneratorDuration } from './animation/generators/utils/calc-duration.mjs';
export { createGeneratorEasing } from './animation/generators/utils/create-generator-easing.mjs';
export { isGenerator } from './animation/generators/utils/is-generator.mjs';
export { DOMKeyframesResolver } from './animation/keyframes/DOMKeyframesResolver.mjs';
export { KeyframeResolver, flushKeyframeResolvers } from './animation/keyframes/KeyframesResolver.mjs';
export { defaultOffset } from './animation/keyframes/offsets/default.mjs';
export { fillOffset } from './animation/keyframes/offsets/fill.mjs';
export { convertOffsetToTimes } from './animation/keyframes/offsets/time.mjs';
export { applyPxDefaults } from './animation/keyframes/utils/apply-px-defaults.mjs';
export { fillWildcards } from './animation/keyframes/utils/fill-wildcards.mjs';
export { cubicBezierAsString } from './animation/waapi/easing/cubic-bezier.mjs';
export { isWaapiSupportedEasing } from './animation/waapi/easing/is-supported.mjs';
export { mapEasingToNativeEasing } from './animation/waapi/easing/map-easing.mjs';
export { supportedWaapiEasing } from './animation/waapi/easing/supported.mjs';
export { startWaapiAnimation } from './animation/waapi/start-waapi-animation.mjs';
export { supportsPartialKeyframes } from './animation/waapi/supports/partial-keyframes.mjs';
export { supportsBrowserAnimation } from './animation/waapi/supports/waapi.mjs';
export { acceleratedValues } from './animation/waapi/utils/accelerated-values.mjs';
export { applyGeneratorOptions } from './animation/waapi/utils/apply-generator.mjs';
export { generateLinearEasing } from './animation/waapi/utils/linear.mjs';
export { addAttrValue, attrEffect } from './effects/attr/index.mjs';
export { propEffect } from './effects/prop/index.mjs';
export { addStyleValue, styleEffect } from './effects/style/index.mjs';
export { svgEffect } from './effects/svg/index.mjs';
export { createRenderBatcher } from './frameloop/batcher.mjs';
export { cancelMicrotask, microtask } from './frameloop/microtask.mjs';
export { time } from './frameloop/sync-time.mjs';
export { isDragActive, isDragging } from './gestures/drag/state/is-active.mjs';
export { setDragLock } from './gestures/drag/state/set-active.mjs';
export { hover } from './gestures/hover.mjs';
export { press } from './gestures/press/index.mjs';
export { isElementKeyboardAccessible } from './gestures/press/utils/is-keyboard-accessible.mjs';
export { isNodeOrChild } from './gestures/utils/is-node-or-child.mjs';
export { isPrimaryPointer } from './gestures/utils/is-primary-pointer.mjs';
export { defaultTransformValue, parseValueFromTransform, readTransformValue } from './render/dom/parse-transform.mjs';
export { getComputedStyle } from './render/dom/style-computed.mjs';
export { setStyle } from './render/dom/style-set.mjs';
export { positionalKeys } from './render/utils/keys-position.mjs';
export { transformPropOrder, transformProps } from './render/utils/keys-transform.mjs';
export { isKeyframesTarget } from './render/utils/is-keyframes-target.mjs';
export { resize } from './resize/index.mjs';
export { observeTimeline } from './scroll/observe.mjs';
export { recordStats } from './stats/index.mjs';
export { activeAnimations } from './stats/animation-count.mjs';
export { statsBuffer } from './stats/buffer.mjs';
export { interpolate } from './utils/interpolate.mjs';
export { isHTMLElement } from './utils/is-html-element.mjs';
export { isSVGElement } from './utils/is-svg-element.mjs';
export { isSVGSVGElement } from './utils/is-svg-svg-element.mjs';
export { mix } from './utils/mix/index.mjs';
export { mixColor, mixLinearColor } from './utils/mix/color.mjs';
export { getMixer, mixArray, mixComplex, mixObject } from './utils/mix/complex.mjs';
export { mixImmediate } from './utils/mix/immediate.mjs';
export { mixNumber } from './utils/mix/number.mjs';
export { invisibleValues, mixVisibility } from './utils/mix/visibility.mjs';
export { resolveElements } from './utils/resolve-elements.mjs';
export { getOriginIndex, stagger } from './utils/stagger.mjs';
export { supportsFlags } from './utils/supports/flags.mjs';
export { supportsLinearEasing } from './utils/supports/linear-easing.mjs';
export { supportsScrollTimeline } from './utils/supports/scroll-timeline.mjs';
export { transform } from './utils/transform.mjs';
export { MotionValue, collectMotionValues, motionValue } from './value/index.mjs';
export { mapValue } from './value/map-value.mjs';
export { attachSpring, springValue } from './value/spring-value.mjs';
export { transformValue } from './value/transform-value.mjs';
export { color } from './value/types/color/index.mjs';
export { hex } from './value/types/color/hex.mjs';
export { hsla } from './value/types/color/hsla.mjs';
export { hslaToRgba } from './value/types/color/hsla-to-rgba.mjs';
export { rgbUnit, rgba } from './value/types/color/rgba.mjs';
export { analyseComplexValue, complex } from './value/types/complex/index.mjs';
export { dimensionValueTypes, findDimensionValueType } from './value/types/dimensions.mjs';
export { defaultValueTypes, getDefaultValueType } from './value/types/maps/defaults.mjs';
export { numberValueTypes } from './value/types/maps/number.mjs';
export { transformValueTypes } from './value/types/maps/transform.mjs';
export { alpha, number, scale } from './value/types/numbers/index.mjs';
export { degrees, percent, progressPercentage, px, vh, vw } from './value/types/numbers/units.mjs';
export { testValueType } from './value/types/test.mjs';
export { getAnimatableNone } from './value/types/utils/animatable-none.mjs';
export { findValueType } from './value/types/utils/find.mjs';
export { getValueAsType } from './value/types/utils/get-as-type.mjs';
export { isMotionValue } from './value/utils/is-motion-value.mjs';
export { isWillChangeMotionValue } from './value/will-change/is.mjs';
export { addValueToWillChange } from './value/will-change/add-will-change.mjs';
export { ViewTransitionBuilder, animateView } from './view/index.mjs';
export { getViewAnimationLayerInfo } from './view/utils/get-layer-info.mjs';
export { getViewAnimations } from './view/utils/get-view-animations.mjs';
export { VisualElement, getFeatureDefinitions, setFeatureDefinitions } from './render/VisualElement.mjs';
export { Feature } from './render/Feature.mjs';
export { DOMVisualElement } from './render/dom/DOMVisualElement.mjs';
export { HTMLVisualElement } from './render/html/HTMLVisualElement.mjs';
export { SVGVisualElement } from './render/svg/SVGVisualElement.mjs';
export { ObjectVisualElement } from './render/object/ObjectVisualElement.mjs';
export { visualElementStore } from './render/store.mjs';
export { checkVariantsDidChange, createAnimationState } from './render/utils/animation-state.mjs';
export { isVariantLabel } from './render/utils/is-variant-label.mjs';
export { isControllingVariants, isVariantNode } from './render/utils/is-controlling-variants.mjs';
export { getVariantContext } from './render/utils/get-variant-context.mjs';
export { resolveVariantFromProps } from './render/utils/resolve-variants.mjs';
export { resolveVariant } from './render/utils/resolve-dynamic-variants.mjs';
export { updateMotionValuesFromProps } from './render/utils/motion-values.mjs';
export { variantPriorityOrder, variantProps } from './render/utils/variant-props.mjs';
export { isAnimationControls } from './render/utils/is-animation-controls.mjs';
export { isForcedMotionValue } from './render/utils/is-forced-motion-value.mjs';
export { setTarget } from './render/utils/setters.mjs';
export { initPrefersReducedMotion } from './render/utils/reduced-motion/index.mjs';
export { createAxis, createAxisDelta, createBox, createDelta } from './projection/geometry/models.mjs';
export { calcAxisDelta, calcBoxDelta, calcLength, calcRelativeAxis, calcRelativeAxisPosition, calcRelativeBox, calcRelativePosition, isNear } from './projection/geometry/delta-calc.mjs';
export { applyAxisDelta, applyBoxDelta, applyPointDelta, applyTreeDeltas, scalePoint, transformAxis, transformBox, translateAxis } from './projection/geometry/delta-apply.mjs';
export { removeAxisDelta, removeAxisTransforms, removeBoxTransforms, removePointDelta } from './projection/geometry/delta-remove.mjs';
export { copyAxisDeltaInto, copyAxisInto, copyBoxInto } from './projection/geometry/copy.mjs';
export { convertBoundingBoxToBox, convertBoxToBoundingBox, transformBoxPoints } from './projection/geometry/conversion.mjs';
export { aspectRatio, axisDeltaEquals, axisEquals, axisEqualsRounded, boxEquals, boxEqualsRounded, isDeltaZero } from './projection/geometry/utils.mjs';
export { has2DTranslate, hasScale, hasTransform } from './projection/utils/has-transform.mjs';
export { measurePageBox, measureViewportBox } from './projection/utils/measure.mjs';
export { eachAxis } from './projection/utils/each-axis.mjs';
export { correctBorderRadius, pixelsToPercent } from './projection/styles/scale-border-radius.mjs';
export { correctBoxShadow } from './projection/styles/scale-box-shadow.mjs';
export { buildProjectionTransform } from './projection/styles/transform.mjs';
export { mixValues } from './projection/animation/mix-values.mjs';
export { delay, delayInSeconds } from './utils/delay.mjs';
export { addDomEvent } from './events/add-dom-event.mjs';
export { resolveMotionValue } from './value/utils/resolve-motion-value.mjs';
export { animateSingleValue } from './animation/animate/single-value.mjs';
export { FlatTree } from './projection/utils/flat-tree.mjs';
export { compareByDepth } from './projection/utils/compare-by-depth.mjs';
export { cleanDirtyNodes, createProjectionNode, propagateDirtyNodes } from './projection/node/create-projection-node.mjs';
export { HTMLProjectionNode, rootProjectionNode } from './projection/node/HTMLProjectionNode.mjs';
export { DocumentProjectionNode } from './projection/node/DocumentProjectionNode.mjs';
export { globalProjectionState } from './projection/node/state.mjs';
export { nodeGroup } from './projection/node/group.mjs';
export { NodeStack } from './projection/shared/stack.mjs';
export { buildHTMLStyles } from './render/html/utils/build-styles.mjs';
export { buildTransform } from './render/html/utils/build-transform.mjs';
export { renderHTML } from './render/html/utils/render.mjs';
export { scrapeMotionValuesFromProps as scrapeHTMLMotionValuesFromProps } from './render/html/utils/scrape-motion-values.mjs';
export { buildSVGAttrs } from './render/svg/utils/build-attrs.mjs';
export { renderSVG } from './render/svg/utils/render.mjs';
export { buildSVGPath } from './render/svg/utils/path.mjs';
export { camelCaseAttributes } from './render/svg/utils/camel-case-attrs.mjs';
export { isSVGTag } from './render/svg/utils/is-svg-tag.mjs';
export { scrapeMotionValuesFromProps as scrapeSVGMotionValuesFromProps } from './render/svg/utils/scrape-motion-values.mjs';
export { camelToDash } from './render/dom/utils/camel-to-dash.mjs';
export { cancelSync, sync } from './frameloop/index-legacy.mjs';
export { addScaleCorrector, scaleCorrectors } from './projection/styles/scale-correction.mjs';
export { hasReducedMotionListener, prefersReducedMotion } from './render/utils/reduced-motion/state.mjs';
export { cancelFrame, frame, frameData, frameSteps } from './frameloop/frame.mjs';
