"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.range = exports.map = exports.curry = exports.compose = exports.PLACE_HOLDER = void 0;
var identity = i => i;
var PLACE_HOLDER = exports.PLACE_HOLDER = {
  '@@functional/placeholder': true
};
var isPlaceHolder = val => val === PLACE_HOLDER;
var curry0 = fn => function _curried() {
  if (arguments.length === 0 || arguments.length === 1 && isPlaceHolder(arguments.length <= 0 ? undefined : arguments[0])) {
    return _curried;
  }
  return fn(...arguments);
};
var curryN = (n, fn) => {
  if (n === 1) {
    return fn;
  }
  return curry0(function () {
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    var argsLength = args.filter(arg => arg !== PLACE_HOLDER).length;
    if (argsLength >= n) {
      return fn(...args);
    }
    return curryN(n - argsLength, curry0(function () {
      for (var _len2 = arguments.length, restArgs = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
        restArgs[_key2] = arguments[_key2];
      }
      var newArgs = args.map(arg => isPlaceHolder(arg) ? restArgs.shift() : arg);
      return fn(...newArgs, ...restArgs);
    }));
  });
};
var curry = fn => curryN(fn.length, fn);
exports.curry = curry;
var range = (begin, end) => {
  var arr = [];
  for (var i = begin; i < end; ++i) {
    arr[i - begin] = i;
  }
  return arr;
};
exports.range = range;
var map = exports.map = curry((fn, arr) => {
  if (Array.isArray(arr)) {
    return arr.map(fn);
  }
  return Object.keys(arr).map(key => arr[key]).map(fn);
});
var compose = exports.compose = function compose() {
  for (var _len3 = arguments.length, args = new Array(_len3), _key3 = 0; _key3 < _len3; _key3++) {
    args[_key3] = arguments[_key3];
  }
  if (!args.length) {
    return identity;
  }
  var fns = args.reverse();
  // first function can receive multiply arguments
  var firstFn = fns[0];
  var tailsFn = fns.slice(1);
  return function () {
    return tailsFn.reduce((res, fn) => fn(res), firstFn(...arguments));
  };
};