import { BrowserRouter as Router, Routes, Route } from 'react-router-dom';
import axios from 'axios';
import Layout from './components/Layout';
import Dashboard from './pages/Dashboard';
import StrategyDetail from './pages/StrategyDetail';
import StrategyWizard from './pages/StrategyWizard';
import Settings from './pages/Settings';
import AuthorizedAccounts from './pages/AuthorizedAccounts';
import PerformanceReports from './pages/PerformanceReports';

// Set base URL for API calls to match deployment path
axios.defaults.baseURL = '/v2';

function App() {
  return (
    <Router basename="/v2">
      <Layout>
        <Routes>
          <Route path="/" element={<Dashboard />} />
          <Route path="/strategy/new" element={<StrategyWizard />} />
          <Route path="/strategy/:id" element={<StrategyDetail />} />
          <Route path="/settings" element={<Settings />} />
          <Route path="/settings/accounts" element={<AuthorizedAccounts />} />
          <Route path="/performance-reports" element={<PerformanceReports />} />
          {/* Placeholders for other sections reusing Dashboard for now */}
          <Route path="/strategies/live" element={<Dashboard filter="live" />} />
          <Route path="/strategies/planning" element={<Dashboard filter="planning" />} />
        </Routes>
      </Layout>
    </Router>
  );
}

export default App;
