from flask import Flask
from flask_sqlalchemy import SQLAlchemy
from flask_migrate import Migrate
from flask_cors import CORS
from config import Config

db = SQLAlchemy()
migrate = Migrate()

def create_app(config_class=Config):
    app = Flask(__name__)
    app.config.from_object(config_class)

    # Initialize extensions
    db.init_app(app)
    migrate.init_app(app, db)
    CORS(app) # Enable CORS for all routes
    
    from apscheduler.schedulers.background import BackgroundScheduler
    scheduler = BackgroundScheduler()
    # Import tasks to ensure they are registered
    # from app.tasks import fetch_data_for_strategies
    # scheduler.add_job(func=fetch_data_for_strategies, trigger="interval", hours=24)
    # scheduler.start()
    
    # Store scheduler in app for access if needed
    app.scheduler = scheduler

    # Register blueprints
    from app.routes import main
    app.register_blueprint(main)

    return app
