from app import db
from app.models import Strategy, Integration, PerformanceData
from app import db
from app.models import Strategy, Integration, PerformanceData
from datetime import datetime, timedelta
import random
import os

def fetch_data_for_strategies():
    """
    Iterates through all strategies and fetches data if integrations exist.
    """
    with db.app.app_context():
        strategies = Strategy.query.all()
        for strategy in strategies:
            print(f"Checking strategy: {strategy.name}")
            # Logic to fetch from GSC/GA4 would go here using stored credentials
            
            # Placeholder: Generate dummy data for demonstration if connected
            if strategy.integrations.count() > 0:
                print(f"Fetching data for {strategy.name}...")
                new_data = PerformanceData(
                    strategy_id=strategy.id,
                    date=datetime.utcnow().date(),
                    clicks=random.randint(100, 1000),
                    impressions=random.randint(1000, 10000),
                    source='GSC'
                )
                db.session.add(new_data)
                db.session.commit()

from pptx import Presentation
from pptx.util import Inches, Pt

def generate_presentation(strategy_id):
    """
    Generates a PowerPoint presentation for the given strategy.
    Returns path to the file.
    """
    strategy = Strategy.query.get(strategy_id)
    if not strategy:
        return None
        
    prs = Presentation()
    
    # Title Slide
    title_slide_layout = prs.slide_layouts[0]
    slide = prs.slides.add_slide(title_slide_layout)
    title = slide.shapes.title
    subtitle = slide.placeholders[1]
    
    title.text = f"SEO Strategy Strategy: {strategy.name}"
    subtitle.text = f"Generated for {strategy.description}\n{datetime.now().strftime('%Y-%m-%d')}"
    
    # Updates Slide
    bullet_slide_layout = prs.slide_layouts[1]
    slide = prs.slides.add_slide(bullet_slide_layout)
    shapes = slide.shapes
    
    title_shape = shapes.title
    title_shape.text = "Recent Updates"
    
    body_shape = shapes.placeholders[1]
    tf = body_shape.text_frame
    
    # Add actual updates
    if strategy.updates.count() > 0:
        for update in strategy.updates:
            p = tf.add_paragraph()
            p.text = f"{update.date.strftime('%b %d')}: {update.description} (Impact: {update.impact_score})"
    else:
        tf.text = "No recent updates recorded."

    # Performance Slide (Placeholder)
    slide = prs.slides.add_slide(bullet_slide_layout)
    slide.shapes.title.text = "Performance Overview"
    slide.placeholders[1].text_frame.text = "Charts would be inserted here based on PerformanceData."
    
    filename = f"strategy_{strategy.id}_report.pptx"
    path = os.path.join(os.getcwd(), filename)
    prs.save(path)
    return path
