"""Add URLs and KPIs to Strategy, credential path to Integration

Revision ID: b985c1ec4725
Revises: 709cdd966af2
Create Date: 2026-01-15 00:21:36.749909

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import sqlite

# revision identifiers, used by Alembic.
revision = 'b985c1ec4725'
down_revision = '709cdd966af2'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('integration', schema=None) as batch_op:
        batch_op.add_column(sa.Column('credentials_path', sa.String(length=512), nullable=True))
        batch_op.drop_column('credentials')

    with op.batch_alter_table('strategy', schema=None) as batch_op:
        batch_op.add_column(sa.Column('monitored_urls', sa.JSON(), nullable=True))
        batch_op.add_column(sa.Column('kpis', sa.JSON(), nullable=True))

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('strategy', schema=None) as batch_op:
        batch_op.drop_column('kpis')
        batch_op.drop_column('monitored_urls')

    with op.batch_alter_table('integration', schema=None) as batch_op:
        batch_op.add_column(sa.Column('credentials', sqlite.JSON(), nullable=True))
        batch_op.drop_column('credentials_path')

    # ### end Alembic commands ###
