"""Add collection dates and benchmark to Strategy

Revision ID: bc365be8592a
Revises: b985c1ec4725
Create Date: 2026-01-15 20:05:26.727458

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = 'bc365be8592a'
down_revision = 'b985c1ec4725'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('strategy', schema=None) as batch_op:
        batch_op.add_column(sa.Column('collection_start_date', sa.Date(), nullable=True))
        batch_op.add_column(sa.Column('collection_end_date', sa.Date(), nullable=True))
        batch_op.add_column(sa.Column('benchmark_mode', sa.String(length=32), nullable=True))

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('strategy', schema=None) as batch_op:
        batch_op.drop_column('benchmark_mode')
        batch_op.drop_column('collection_end_date')
        batch_op.drop_column('collection_start_date')

    # ### end Alembic commands ###
