"""Add enhanced performance reports with report templates and URL metrics

Revision ID: cb740456d90c
Revises: bc365be8592a
Create Date: 2026-01-29 22:46:27.165385

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = 'cb740456d90c'
down_revision = 'bc365be8592a'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('performance_report',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('name', sa.String(length=128), nullable=False),
    sa.Column('created_at', sa.DateTime(), nullable=True),
    sa.Column('gsc_credentials_path', sa.String(length=512), nullable=True),
    sa.Column('gsc_property_id', sa.String(length=256), nullable=True),
    sa.Column('ga4_credentials_path', sa.String(length=512), nullable=True),
    sa.Column('ga4_property_id', sa.String(length=256), nullable=True),
    sa.Column('urls', sa.JSON(), nullable=True),
    sa.Column('start_date', sa.Date(), nullable=True),
    sa.Column('end_date', sa.Date(), nullable=True),
    sa.Column('insights', sa.Text(), nullable=True),
    sa.Column('recommendations', sa.JSON(), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('report_template',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('name', sa.String(length=128), nullable=False),
    sa.Column('description', sa.Text(), nullable=True),
    sa.Column('category', sa.String(length=64), nullable=True),
    sa.Column('config', sa.JSON(), nullable=True),
    sa.Column('created_at', sa.DateTime(), nullable=True),
    sa.Column('is_system', sa.Boolean(), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('url_metrics',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('report_id', sa.Integer(), nullable=False),
    sa.Column('url', sa.String(length=512), nullable=False),
    sa.Column('clicks', sa.Integer(), nullable=True),
    sa.Column('impressions', sa.Integer(), nullable=True),
    sa.Column('ctr', sa.Float(), nullable=True),
    sa.Column('position', sa.Float(), nullable=True),
    sa.Column('sessions', sa.Integer(), nullable=True),
    sa.Column('pageviews', sa.Integer(), nullable=True),
    sa.Column('avg_session_duration', sa.Float(), nullable=True),
    sa.Column('bounce_rate', sa.Float(), nullable=True),
    sa.Column('lcp', sa.Float(), nullable=True),
    sa.Column('fid', sa.Float(), nullable=True),
    sa.Column('cls', sa.Float(), nullable=True),
    sa.Column('rich_results', sa.JSON(), nullable=True),
    sa.Column('queries', sa.JSON(), nullable=True),
    sa.Column('keyword_cloud_path', sa.String(length=512), nullable=True),
    sa.Column('publish_date', sa.Date(), nullable=True),
    sa.Column('change_details', sa.Text(), nullable=True),
    sa.ForeignKeyConstraint(['report_id'], ['performance_report.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('url_metrics')
    op.drop_table('report_template')
    op.drop_table('performance_report')
    # ### end Alembic commands ###
