"""Add BenchmarkData model for imported metrics

Revision ID: e1fb147b26ed
Revises: cb740456d90c
Create Date: 2026-01-31 05:50:03.636673

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = 'e1fb147b26ed'
down_revision = 'cb740456d90c'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('benchmark_data',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('strategy_id', sa.Integer(), nullable=False),
    sa.Column('platform', sa.String(length=32), nullable=False),
    sa.Column('date', sa.Date(), nullable=False),
    sa.Column('url', sa.String(length=512), nullable=False),
    sa.Column('clicks', sa.Integer(), nullable=True),
    sa.Column('impressions', sa.Integer(), nullable=True),
    sa.Column('ctr', sa.Float(), nullable=True),
    sa.Column('position', sa.Float(), nullable=True),
    sa.Column('sessions', sa.Integer(), nullable=True),
    sa.Column('pageviews', sa.Integer(), nullable=True),
    sa.Column('avg_session_duration', sa.Float(), nullable=True),
    sa.Column('bounce_rate', sa.Float(), nullable=True),
    sa.Column('imported_at', sa.DateTime(), nullable=True),
    sa.ForeignKeyConstraint(['strategy_id'], ['strategy.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    with op.batch_alter_table('benchmark_data', schema=None) as batch_op:
        batch_op.create_index('idx_strategy_platform_date', ['strategy_id', 'platform', 'date'], unique=False)

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('benchmark_data', schema=None) as batch_op:
        batch_op.drop_index('idx_strategy_platform_date')

    op.drop_table('benchmark_data')
    # ### end Alembic commands ###
