# SEO Strategy Tracker V3

## Overview

Version 3 of the SEO Strategy Tracker combines the detailed wizard forms from v1 with the modern React + Bootstrap architecture. Built with React + TypeScript frontend and Flask backend.

## Features

- ✨ **Multi-Step Strategy Wizard** - Comprehensive 4-step form for creating new strategies
- 🎨 **10 Color Themes** - Beautiful pre-configured themes (Deep Ocean, Midnight Purple, Forest Green, etc.)
- 📊 **Dashboard** - View and filter all strategies by status (Planning/Pending/Live)
- ⚙️ **Settings** - Customize themes, validation rules, and preferences
- 🔄 **Per-Test Data Sources** - Connect GSC and GA4 individually for each strategy
- 📁 **File Upload** - Import benchmark and performance data via CSV/Excel
- 📈 **Strategy Tracking** - Automatic status calculation based on business rules

## Tech Stack

### Frontend
- React 18 + TypeScript
- React Bootstrap (Bootstrap 5)
- React Router v6
- Axios for API calls
- Vite for build tooling

### Backend
- Flask 3.0
- SQLAlchemy (ORM)
- Flask-Migrate (database migrations)
- Flask-CORS
- Google OAuth libraries (GSC/GA4 integration)

## Project Structure

```
v3/
├── client/                 # React frontend
│   ├── src/
│   │   ├── components/    # Reusable UI components
│   │   ├── pages/         # Page components
│   │   ├── context/       # React Context providers
│   │   ├── services/      # API service layer
│   │   ├── styles/        # SCSS theme files
│   │   └── utils/         # Helper functions
│   └── public/
└── server/                # Flask backend
    ├── app/
    │   ├── models.py      # Database models
    │   ├── routes.py      # API endpoints
    │   └── services/      # Business logic
    ├── instance/          # SQLite database
    └── uploads/           # File uploads
```

## Getting Started

### Backend Setup

1. Navigate to server directory:
   ```bash
   cd /mnt/media_drive2/site-root/reporting.jetlifecdn.com/v3/server
   ```

2. Create and activate virtual environment:
   ```bash
   python3 -m venv venv
   source venv/bin/activate
   ```

3. Install dependencies:
   ```bash
   pip install -r requirements.txt
   ```

4. Initialize database:
   ```bash
   python init_db.py
   ```

5. Run Flask server (development):
   ```bash
   python run.py
   ```
   Server runs on `http://localhost:5004`

### Frontend Setup

1. Navigate to client directory:
   ```bash
   cd /mnt/media_drive2/site-root/reporting.jetlifecdn.com/v3/client
   ```

2. Install dependencies (already done if you followed setup):
   ```bash
   npm install
   ```

3. Run development server:
   ```bash
   npm run dev
   ```
   Frontend runs on `http://localhost:5173`

### Access the Application

Open your browser to: `http://localhost:5173/v3/`

## API Endpoints

### Strategies
- `GET /api/strategies` - List all strategies (optional `?status=` filter)
- `POST /api/strategies` - Create new strategy
- `GET /api/strategies/:id` - Get strategy details
- `PUT /api/strategies/:id` - Update strategy
- `DELETE /api/strategies/:id` - Delete strategy
- `GET /api/strategies/:id/status` - Get calculated status

### Settings
- `GET /api/settings` - Get user settings
- `PUT /api/settings` - Update settings

### OAuth (Coming Soon)
- `POST /api/oauth/connect/gsc` - Connect Google Search Console
- `POST /api/oauth/connect/ga4` - Connect Google Analytics 4

### Data Import (Coming Soon)
- `POST /api/data/import` - Import data from GSC/GA4
- `POST /api/data/upload/:id` - Upload CSV/Excel file

## Database Models

### Strategy
Core entity representing an SEO strategy/test with status tracking (Planning/Pending/Live).

### Integration
Per-test OAuth connections to GSC and GA4 with selected metrics.

### BenchmarkData
Baseline performance data for comparison.

### PerformanceData
Live test performance data post-implementation.

### FileUpload
Track uploaded CSV/Excel files.

### Settings
User preferences and theme selection.

## Color Themes

1. **Deep Ocean** - Dark blue/teal (Default)
2. **Midnight Purple** - Dark purple/pink gradient
3. **Forest Green** - Dark green/emerald
4. **Sunset Orange** - Deep orange/coral
5. **Cyber Blue** - Electric blue/cyan
6. **Royal** - Deep purple/gold
7. **Monochrome** - Gray scale with accent
8. **Cherry Blossom** - Pink/rose
9. **Arctic** - Ice blue/white
10. **Amber** - Dark amber/yellow

Change theme in Settings page. Theme persists across sessions.

## Development Notes

- Frontend proxy configured in `vite.config.ts` to route `/api` calls to Flask backend
- Database uses SQLite for development (production can use PostgreSQL)
- OAuth integration currently stubbed out - implementation coming soon
- File upload templates and processing - implementation coming soon

## Next Steps

- [ ] Implement GSC OAuth integration
- [ ] Implement GA4 OAuth integration with data point selector
- [ ] Add file upload processing with template downloads
- [ ] Implement data comparison charts
- [ ] Add export functionality (PDF, Excel)
- [ ] Build advanced reporting module
- [ ] Add scheduled data sync

## License

Proprietary - Jetlife Technologies
