"use client";
import {
  CardHeaderContext_default
} from "./chunk-EPXAERZS.js";
import {
  NavbarContext_default
} from "./chunk-CRUOIM4E.js";
import {
  Nav_default,
  useNavItem
} from "./chunk-JOZ55W36.js";
import "./chunk-CU5YZ6EB.js";
import "./chunk-NUSLWK4A.js";
import {
  makeEventKey
} from "./chunk-XKGL6Q6W.js";
import "./chunk-KFVRIOLX.js";
import {
  Anchor_default
} from "./chunk-TJGQGTIY.js";
import "./chunk-VIRLNLFG.js";
import "./chunk-WWAX3C4I.js";
import {
  useUncontrolled
} from "./chunk-XPO4K6G5.js";
import "./chunk-RI5XMXIA.js";
import "./chunk-SHTFLKXO.js";
import {
  require_classnames,
  useBootstrapPrefix
} from "./chunk-HBXFE2DT.js";
import {
  require_jsx_runtime
} from "./chunk-7HXCKB66.js";
import {
  require_react
} from "./chunk-RY7GF66K.js";
import {
  __toESM
} from "./chunk-G3PMV62Z.js";

// node_modules/react-bootstrap/esm/Nav.js
var import_classnames3 = __toESM(require_classnames());
var React3 = __toESM(require_react());
var import_react = __toESM(require_react());

// node_modules/react-bootstrap/esm/NavItem.js
var React = __toESM(require_react());
var import_classnames = __toESM(require_classnames());
var import_jsx_runtime = __toESM(require_jsx_runtime());
var NavItem = React.forwardRef(({
  className,
  bsPrefix,
  as: Component = "div",
  ...props
}, ref) => {
  bsPrefix = useBootstrapPrefix(bsPrefix, "nav-item");
  return (0, import_jsx_runtime.jsx)(Component, {
    ref,
    className: (0, import_classnames.default)(className, bsPrefix),
    ...props
  });
});
NavItem.displayName = "NavItem";
var NavItem_default = NavItem;

// node_modules/react-bootstrap/esm/NavLink.js
var import_classnames2 = __toESM(require_classnames());
var React2 = __toESM(require_react());
var import_jsx_runtime2 = __toESM(require_jsx_runtime());
var NavLink = React2.forwardRef(({
  bsPrefix,
  className,
  as: Component = Anchor_default,
  active,
  eventKey,
  disabled = false,
  ...props
}, ref) => {
  bsPrefix = useBootstrapPrefix(bsPrefix, "nav-link");
  const [navItemProps, meta] = useNavItem({
    key: makeEventKey(eventKey, props.href),
    active,
    disabled,
    ...props
  });
  return (0, import_jsx_runtime2.jsx)(Component, {
    ...props,
    ...navItemProps,
    ref,
    disabled,
    className: (0, import_classnames2.default)(className, bsPrefix, disabled && "disabled", meta.isActive && "active")
  });
});
NavLink.displayName = "NavLink";
var NavLink_default = NavLink;

// node_modules/react-bootstrap/esm/Nav.js
var import_jsx_runtime3 = __toESM(require_jsx_runtime());
var Nav = React3.forwardRef((uncontrolledProps, ref) => {
  const {
    as = "div",
    bsPrefix: initialBsPrefix,
    variant,
    fill = false,
    justify = false,
    navbar,
    navbarScroll,
    className,
    activeKey,
    ...props
  } = useUncontrolled(uncontrolledProps, {
    activeKey: "onSelect"
  });
  const bsPrefix = useBootstrapPrefix(initialBsPrefix, "nav");
  let navbarBsPrefix;
  let cardHeaderBsPrefix;
  let isNavbar = false;
  const navbarContext = (0, import_react.useContext)(NavbarContext_default);
  const cardHeaderContext = (0, import_react.useContext)(CardHeaderContext_default);
  if (navbarContext) {
    navbarBsPrefix = navbarContext.bsPrefix;
    isNavbar = navbar == null ? true : navbar;
  } else if (cardHeaderContext) {
    ({
      cardHeaderBsPrefix
    } = cardHeaderContext);
  }
  return (0, import_jsx_runtime3.jsx)(Nav_default, {
    as,
    ref,
    activeKey,
    className: (0, import_classnames3.default)(className, {
      [bsPrefix]: !isNavbar,
      [`${navbarBsPrefix}-nav`]: isNavbar,
      [`${navbarBsPrefix}-nav-scroll`]: isNavbar && navbarScroll,
      [`${cardHeaderBsPrefix}-${variant}`]: !!cardHeaderBsPrefix,
      [`${bsPrefix}-${variant}`]: !!variant,
      [`${bsPrefix}-fill`]: fill,
      [`${bsPrefix}-justified`]: justify
    }),
    ...props
  });
});
Nav.displayName = "Nav";
var Nav_default2 = Object.assign(Nav, {
  Item: NavItem_default,
  Link: NavLink_default
});
export {
  Nav_default2 as default
};
//# sourceMappingURL=react-bootstrap_Nav.js.map
