import { BrowserRouter as Router, Routes, Route } from 'react-router-dom';
import { ThemeProvider } from './context/ThemeContext';
import { ToastProvider } from './context/ToastContext';
import Layout from './components/Layout/Layout';
import Dashboard from './pages/Dashboard';
import StrategyWizard from './pages/StrategyWizard';
import StrategyDetail from './pages/StrategyDetail';
import Reports from './pages/Reports';
import Settings from './pages/Settings';

function App() {
  return (
    <ThemeProvider>
      <ToastProvider>
        <Router basename="/v3">
          <Layout>
            <Routes>
              <Route path="/" element={<Dashboard />} />
              <Route path="/strategy/new" element={<StrategyWizard />} />
              <Route path="/strategy/:id" element={<StrategyDetail />} />
              <Route path="/reports" element={<Reports />} />
              <Route path="/quotes" element={<div className="p-5 text-center"><h1>TEST Page</h1><p>Placeholder for Quotes/Test functionality</p></div>} />
              <Route path="/settings" element={<Settings />} />
            </Routes>
          </Layout>
        </Router>
      </ToastProvider>
    </ThemeProvider>
  );
}

export default App;

