# Google OAuth Configuration Guide

To enable Google Search Console (GSC) and Google Analytics 4 (GA4) integrations, you must configure a project in the Google Cloud Platform (GCP) and update your application settings.

## 1. Google Cloud Console Setup

### A. Create/Select Project
1. Go to the [Google Cloud Console](https://console.cloud.google.com/).
2. Create a new project or select your existing project.

### B. Enable APIs
You need to enable the specific APIs you want to access.
1. Navigate to **APIs & Services** > **Library**.
2. Search for and **Enable** the following APIs:
   - **Google Search Console API**
   - **Google Analytics Data API** (for GA4)

### C. Configure OAuth Consent Screen
1. Navigate to **APIs & Services** > **OAuth consent screen**.
2. Select **External** (unless you are a G-Suite user limiting to your org) and click **Create**.
3. Fill in the App Information (App name, support email, etc.).
4. **Scopes**: You can skip manually adding scopes here as the app requests them dynamically, or add:
   - `../auth/webmasters.readonly`
   - `../auth/analytics.readonly`
5. **Test Users**: If your app is in "Testing" status, you **must** add the email addresses of the Google Accounts you intend to use for testing (e.g., your personal email).

### D. Create Credentials
1. Navigate to **APIs & Services** > **Credentials**.
2. Click **Create Credentials** > **OAuth client ID**.
3. **Application type**: Select **Web application**.
4. **Name**: Enter a name (e.g., "SEO Reporting App V3").
5. **Authorized JavaScript origins**:
   - `https://reporting.jetlifecdn.com`
   - `http://localhost:5173` (for local development)
6. **Authorized redirect URIs**:
   - `https://reporting.jetlifecdn.com/v3/api/oauth/callback`
   - `http://localhost:5004/api/oauth/callback` (for local development)
7. Click **Create**.
8. Copy the **Client ID** and **Client Secret**.

## 2. Application Configuration

Update your server environment variables with the credentials created above.

1. Open `/mnt/media_drive2/site-root/reporting.jetlifecdn.com/v3/server/.env`
2. Update the following values:

```bash
GOOGLE_CLIENT_ID=your_client_id_here
GOOGLE_CLIENT_SECRET=your_client_secret_here
# Ensure this matches EXACTLY what you entered in GCP Console
GOOGLE_REDIRECT_URI=https://reporting.jetlifecdn.com/v3/api/oauth/callback
```

## 3. Important Notes

- **Redirect URI Mismatch**: This is the most common error. The `GOOGLE_REDIRECT_URI` in your `.env` file must perfectly match one of the entries in the "Authorized redirect URIs" list in Google Cloud Console.
- **Test Mode**: While in "Testing" mode (default for new apps), only added Test Users can authorize the app. The token expires in 7 days requiring re-login.
- **Production**: To make it available to anyone, you must "Publish" the app. This may require verification by Google depending on the sensitive scopes used.
