"""Initialize the database with migrations"""
from app import create_app, db
from app.models import Strategy, Integration, BenchmarkData, PerformanceData, FileUpload, Settings

app = create_app()

with app.app_context():
    # Create all tables
    db.create_all()
    
    # Create default settings if none exist
    if Settings.query.count() == 0:
        default_settings = Settings(
            theme_variant=1,
            required_fields_enabled=True,
            advanced_reporting_enabled=False
        )
        db.session.add(default_settings)
        db.session.commit()
        print("✓ Created default settings")
    
    print("✓ Database initialized successfully!")
    print(f"  - Tables created: {len(db.metadata.tables)}")
    print(f"  - Database URI: {app.config['SQLALCHEMY_DATABASE_URI']}")
