# Enhanced Performance Reports - Feature Documentation

## Overview

The enhanced Performance Reports feature provides comprehensive SEO performance tracking with:
1. **Scoped OAuth Integration** - Connect GSC and GA4 accounts per report
2. **Deep Data Analysis** - Rich Results, Core Web Vitals, per-page queries, keyword clouds
3. **Report Templates** - 10 pre-configured report types for common SEO analyses
4. **Advanced Visualizations** - Interactive charts with Chart.js
5. **AI-Powered Insights** - Automated recommendations and actionable insights

---

## Feature 1: Scoped OAuth & Account Linking

### How It Works

Each performance report has its own independent OAuth connections to GSC and GA4. This means:
- Different reports can use different Google accounts
- Credentials are stored securely per-report
- No cross-contamination between reports

### Setup Process

1. **Create URLs and Date Range**
   - Add URLs you want to track
   - Set start and end dates for data collection

2. **Connect Google Search Console (GSC)**
   - Click "Connect GSC" button
   - Authorize with your Google account
   - Set the property URL (e.g., `sc-domain:example.com`)

3. **Connect Google Analytics 4 (GA4)**
   - Click "Connect GA4" button
   - Authorize with your Google account  
   - Set the property ID (e.g., `123456789`)

4. **Confirmation Step**
   - Before fetching data, you'll see a confirmation modal
   - Review the URLs and date range
   - Confirm to proceed with data fetch

### Data Fetched

#### From Google Search Console:
- **Basic Metrics**: Clicks, Impressions, CTR, Average Position
- **Per-Page Queries**: Top 100 queries for each URL
- **Rich Results**: Detected rich result types (Recipe, FAQ, How-to, etc.)
- **Search Appearances**: All search appearance types

#### From Google Analytics 4:
- **Traffic Metrics**: Sessions, Pageviews, Avg Session Duration
- **Engagement**: Bounce Rate, Conversions
- **Core Web Vitals**: LCP, FID, CLS (if configured in GA4)

---

## Feature 2: Report Templates

### Available Templates

1. **Content Performance Deep Dive**
   - Category: Performance
   - Best For: Content marketers analyzing article performance
   - Insights: Top content, keyword diversity, conversion funnel
   - Recommendations: Content optimization, internal linking, keyword targeting

2. **Technical SEO Health Check**
   - Category: Technical
   - Best For: Technical SEO audits
   - Insights: CWV performance, mobile vs desktop gaps, indexing issues
   - Recommendations: Speed optimization, mobile UX, technical fixes

3. **Keyword Rankings & Opportunities**
   - Category: Keywords
   - Best For: Keyword strategy and ranking analysis
   - Insights: Ranking trends, quick wins (position 11-20), cannibalization
   - Recommendations: Priority keywords, content consolidation, new opportunities

4. **Conversion Path Analysis**
   - Category: Conversion
   - Best For: Tracking organic search to conversion
   - Insights: Top converting pages, device attribution, funnel drop-offs
   - Recommendations: Landing page optimization, CTA improvements

5. **Competitive Visibility Analysis**
   - Category: Competitive
   - Best For: Understanding search visibility
   - Insights: Visibility trends, impression share, position distribution
   - Recommendations: Content gaps, title optimization, featured snippets

6. **Rich Results Performance**
   - Category: Rich Results
   - Best For: Schema markup and rich results analysis
   - Insights: Current coverage, rich result CTR vs standard
   - Recommendations: Schema to implement, rich result optimization

7. **Content Refresh ROI**
   - Category: Content
   - Best For: Measuring content update impact
   - Insights: Before/after comparison, time to impact, ROI
   - Recommendations: Which content to refresh next, update best practices

8. **Mobile SEO Performance**
   - Category: Mobile
   - Best For: Mobile-specific analysis
   - Insights: Mobile vs desktop gaps, mobile usability, mobile CWV
   - Recommendations: Mobile speed, touch targets, responsive fixes

9. **Local SEO Dashboard**
   - Category: Local
   - Best For: Local business SEO
   - Insights: Local visibility, top local queries, maps performance
   - Recommendations: GMB optimizations, local content, citations

10. **Executive SEO Summary**
    - Category: Executive
    - Best For: High-level stakeholder reporting
    - Insights: KPIs, trends, business impact
    - Recommendations: Strategic priorities, investment areas

### How to Use Templates

1. Click "Report Templates" button
2. Browse templates by category
3. Click on a template to generate a report
4. The report will be pre-configured with the template's settings
5. Connect your accounts and fetch data as normal

---

## Feature 3: Advanced Data Insights

### Keyword Clouds

For each URL with query data, a custom keyword cloud is generated:
- **Weighted by Performance**: Words sized by clicks + impressions
- **Color-Coded**: Viridis colormap for visual appeal
- **Filtered**: Common stop words removed
- **Auto-Generated**: Created during data fetch

### Rich Results Detection

The system automatically detects and displays:
- Recipe markup
- FAQ schema
- How-to structured data
- Job postings
- Product snippets
- Events
- Videos
- Review snippets
- AMP pages

### Core Web Vitals Analysis

When available from GA4, CWV metrics are tracked:
- **LCP (Largest Contentful Paint)**: Target < 2.5s
- **FID (First Input Delay)**: Target < 100ms  
- **CLS (Cumulative Layout Shift)**: Target < 0.1

Issues are automatically flagged in recommendations.

---

## Feature 4: AI-Generated Recommendations

### Recommendation Types

**Critical** (Red Border)
- Immediate action required
- Examples: Poor CWV scores, very low CTR

**Important** (Orange Border)
- Should be addressed soon
- Examples: Rankings beyond page 1, missing rich results

**Opportunity** (Blue Border)
- Optimization opportunities
- Examples: Quick win keywords, untapped rich results

### Recommendation Structure

Each recommendation includes:
- **Title**: Clear, actionable headline
- **Description**: Context and impact
- **Category**: Area of focus (CTR, Rankings, CWV, etc.)
- **Actions**: Specific steps to take

---

## Feature 5: Chart Visualizations

### Available Chart Types

1. **Bar Chart - Traffic**
   - Compares Clicks vs Sessions across URLs
   - Best for: Overall traffic comparison

2. **CTR Performance**
   - Line chart of CTR across URLs
   - Best for: Identifying CTR outliers

3. **Position Rankings**
   - Bar chart of average positions (inverted scale)
   - Best for: Ranking distribution

4. **Pie Chart - Distribution**
   - Click distribution across URLs
   - Best for: Understanding traffic concentration

5. **Core Web Vitals**
   - Average CWV scores
   - Best for: Technical health overview

### Customization

Charts use Chart.js with:
- Dark theme matching UI
- Interactive tooltips
- Responsive design
- Color-coded data series

---

## API Endpoints Reference

### Performance Reports

```
GET    /api/performance-reports                    - List all reports
POST   /api/performance-reports                    - Create new report
GET    /api/performance-reports/:id                - Get specific report
POST   /api/performance-reports/:id/fetch-data     - Fetch data from GSC/GA4
GET    /api/performance-reports/:id/chart-data     - Get chart-ready data
GET    /api/performance-reports/:id/export         - Export as CSV
```

### OAuth Management

```
POST   /api/performance-reports/:id/connect-oauth  - Initiate OAuth flow
GET    /api/performance-reports/oauth-callback     - OAuth callback handler
POST   /api/performance-reports/:id/set-property   - Set GSC/GA4 property ID
```

### Report Templates

```
GET    /api/report-templates                       - List all templates
GET    /api/report-templates/:id                   - Get template details
POST   /api/report-templates/:id/generate          - Generate from template
```

### Visualizations

```
GET    /api/performance-reports/:id/wordcloud/:url_metric_id  - Get keyword cloud image
```

---

## Data Flow

1. **User Creates Report**
   - Enters URLs and date range
   - Report saved to database

2. **OAuth Connection**
   - User connects GSC and/or GA4
   - Credentials saved securely per-report

3. **Property Configuration**
   - User sets GSC site URL (e.g., `sc-domain:example.com`)
   - User sets GA4 property ID (e.g., `123456789`)

4. **Data Fetch Confirmation**
   - System shows confirmation modal
   - User reviews URLs and timeframe
   - User confirms to proceed

5. **Data Collection**
   - Backend fetches from GSC API (queries, rich results, performance)
   - Backend fetches from GA4 API (sessions, CWV, engagement)
   - Keyword clouds generated for each URL
   - Data saved to URLMetrics table

6. **Insight Generation**
   - AI analyzes all metrics
   - Identifies patterns and issues
   - Generates 5+ recommendations
   - Categorizes by priority

7. **Display**
   - Charts rendered with Chart.js
   - Insights displayed in markdown
   - Recommendations shown with action items
   - Keyword clouds displayed per URL

---

## Database Schema

### PerformanceReport
- `id`: Primary key
- `name`: Report name
- `created_at`: Creation timestamp
- `gsc_credentials_path`: Path to GSC OAuth credentials
- `gsc_property_id`: GSC property URL
- `ga4_credentials_path`: Path to GA4 OAuth credentials
- `ga4_property_id`: GA4 property ID
- `urls`: JSON array of tracked URLs
- `start_date`: Data collection start
- `end_date`: Data collection end
- `insights`: Generated insights text
- `recommendations`: JSON array of recommendations

### URLMetrics
- `id`: Primary key
- `report_id`: Foreign key to PerformanceReport
- `url`: Full URL
- `clicks`, `impressions`, `ctr`, `position`: GSC metrics
- `sessions`, `pageviews`, `avg_session_duration`, `bounce_rate`: GA4 metrics
- `lcp`, `fid`, `cls`: Core Web Vitals
- `rich_results`: JSON array of rich result types
- `queries`: JSON array of query objects
- `keyword_cloud_path`: Path to generated word cloud image
- `publish_date`: Optional publish/update date
- `change_details`: Optional change description

### ReportTemplate
- `id`: Primary key
- `name`: Template name
- `description`: What the template does
- `category`: Template category
- `config`: JSON configuration
- `is_system`: System vs user template

---

## Best Practices

### 1. URL Targeting

✅ **DO:**
- Use specific URLs for focused analysis
- Include publish dates for content refresh tracking
- Document what changed in the "Details" field

❌ **DON'T:**
- Mix different content types in one report
- Leave change details empty for updated content
- Use overly broad date ranges (stick to meaningful periods)

### 2. Account Connections

✅ **DO:**
- Verify the correct property is selected
- Test with a single URL first
- Check that data is flowing before adding many URLs

❌ **DON'T:**
- Connect the wrong Google account
- Skip the property ID setup
- Ignore OAuth errors

### 3. Data Interpretation

✅ **DO:**
- Review all recommendations
- Check keyword clouds for query intent
- Compare CWV across URLs
- Export data for further analysis

❌ **DON'T:**
- Ignore critical recommendations
- Overlook rich result opportunities
- Skip the confirmation modal

### 4. Template Usage

✅ **DO:**
- Choose templates matching your goals
- Use "Executive Summary" for stakeholders
- Use "Content Refresh ROI" for tracking updates

❌ **DON'T:**
- Use the wrong template for your use case
- Ignore template-specific insights

---

## Troubleshooting

### "Error connecting GSC/GA4"
- **Cause**: OAuth credentials issue
- **Fix**: Check `.env-conf` file has valid `client_id` and `client_secret`

### "No data fetched"
- **Cause**: Wrong property ID or no data in date range
- **Fix**: Verify property ID matches your GSC/GA4 property

### "Keyword cloud not generated"
- **Cause**: No query data available
- **Fix**: Ensure date range has query traffic, check GSC permissions

### "CWV data shows 0"
- **Cause**: GA4 not configured for CWV
- **Fix**: Enable experimental CWV metrics in GA4 or use PageSpeed Insights

### "Charts not displaying"
- **Cause**: Chart.js not loaded
- **Fix**: Check browser console, ensure Chart.js dependencies installed

---

## Future Enhancements

Planned features include:
- Historical trend tracking across multiple reports
- Automated report scheduling
- Slack/email notifications for insights
- Custom report template builder
- Competitor comparison mode
- Integration with PageSpeed Insights for CWV
- Automated A/B test tracking
- Multi-language support for international SEO

---

## Support

For questions or issues:
1. Check this documentation
2. Review the troubleshooting section
3. Check application logs in `/server/instance/`
4. Verify all dependencies are installed

## Version

- **Version**: 2.0.0
- **Last Updated**: 2026-01-29
- **Author**: SEO Reporting Platform Team
