# Quick Start Guide: Data Import Feature

## Purpose
Import baseline performance data from Google Search Console and Google Analytics 4 before running a test. Compare this benchmark data against live test results to measure impact.

## Prerequisites
1. Strategy must have GSC and/or GA4 connected (via Integrations dropdown)
2. Strategy must have monitored URLs configured
3. Accounts must have proper permissions for the URLs

## Step-by-Step Usage

### 1. Navigate to Strategy Detail Page
- Click on any strategy from the Dashboard
- You'll see the "Performance Data" section

### 2. Import Benchmark Data
1. Click the **"Import Data"** button (gradient blue-purple)
2. Watch the progress bar fill as data is fetched
3. The panel will automatically expand when complete

### 3. View Imported Data
The collapsible panel shows:
- **Total record count** in the badge
- **Two tabs**: Switch between GSC and GA4 data
- **Data table** with sortable columns

### 4. Sort the Data
- Click any column header to sort
- Click again to reverse sort direction
- Look for the arrow icons (↑/↓) showing active sort

### 5. Set Benchmark Period (Optional)
1. Select **Start Date** in the date picker
2. Select **End Date** in the date picker
3. Table automatically filters to show only that range
4. Click **"Clear"** to remove the filter

### 6. Analyze Results

#### For GSC Data:
- **Clicks**: How many users clicked your URLs
- **Impressions**: How many times URLs appeared in search
- **CTR**: Click-through rate percentage
- **Position**: Average ranking position

#### For GA4 Data:
- **Sessions**: Number of user sessions
- **Pageviews**: Total page views
- **Bounce Rate**: Percentage of single-page sessions
- **Avg Duration**: Average session length (MM:SS)

### 7. Compare to Live Data
After your test is live:
1. Set benchmark dates to pre-test period
2. Compare metrics to current live performance
3. Calculate percentage changes
4. Identify which URLs improved/declined

## Tips & Tricks

### Best Practices
- **Import before test launch**: Capture clean baseline data
- **Use 30-day window**: Enough data for statistical significance
- **Export screenshots**: Document baseline for reports
- **Regular imports**: Update benchmark as needed

### Date Range Selection
- **Short test (1-2 weeks)**: Import last 14-30 days
- **Medium test (1 month)**: Import last 30-60 days
- **Long test (3+ months)**: Import last 90 days

### Sorting Strategies
- **By Clicks**: Find highest-traffic pages
- **By Position**: Identify ranking opportunities
- **By CTR**: Spot title/description issues
- **By Date**: See chronological trends

### Benchmark Filtering
- **Week-over-week**: Filter to same weekdays
- **Seasonal baseline**: Match time periods
- **Event exclusion**: Filter out anomalies
- **Stable period**: Avoid major changes

## Common Use Cases

### Use Case 1: Title Tag Test
1. Import 30 days of GSC data before title changes
2. Set benchmark to full 30-day period
3. After test, compare CTR changes
4. Sort by CTR to find biggest improvements

### Use Case 2: Content Refresh
1. Import GSC + GA4 data for 60 days
2. Note baseline clicks, sessions, position
3. After refresh, track daily changes
4. Filter benchmark to exclude outliers

### Use Case 3: Multi-URL Campaign
1. Import data for all campaign URLs
2. Sort by impressions to prioritize
3. Set benchmark to pre-launch period
4. Track aggregate impact across URLs

### Use Case 4: Seasonal Comparison
1. Import same date range from last year
2. Compare year-over-year performance
3. Account for seasonal traffic patterns
4. Normalize for market changes

## Troubleshooting

### "Platform not connected"
- Go to Integrations dropdown
- Click "Connect GSC" or "Connect GA4"
- Complete OAuth flow
- Try import again

### "No monitored URLs configured"
- Click "Edit" button on strategy
- Add URLs (one per line)
- Save changes
- Try import again

### No data returned
- Verify URLs exist in GSC/GA4
- Check date range (data may not exist)
- Ensure property ID is correct
- Check OAuth token hasn't expired

### Import is slow
- Normal behavior for large date ranges
- Fetches day-by-day for granularity
- Consider shorter date range for testing
- Progress bar shows real-time status

## Data Storage Notes

- Data is permanently stored in database
- Re-importing same period updates existing records
- No automatic cleanup (manual deletion TBD)
- Each import creates individual daily records
- Organized by strategy_id, platform, date, URL

## Future Enhancements (Coming Soon)

- 📊 **Visual Charts**: Plot imported data on graphs
- 📈 **Comparison Overlays**: Overlay benchmark vs. live
- 💾 **Export CSV**: Download benchmark data
- 🔄 **Auto-Import**: Schedule periodic imports
- 🎯 **URL Filtering**: Filter table by specific URLs
- 📅 **Date Presets**: Quick select last 7/30/90 days
- 🔔 **Alerts**: Notify on significant deviations
- 📑 **Property Picker**: Select which property to import from

## Support

If you encounter issues:
1. Check browser console for errors
2. Verify API credentials are valid
3. Ensure strategy has required connections
4. Review DATA_IMPORT_FEATURE.md for technical details

---

**Remember**: The goal of benchmark data is to establish a baseline for comparison. Import data during a stable period before making any changes, then use it as a reference point to measure the impact of your SEO tests and optimizations.
