# Report Templates - Quick Reference Guide

## Template Selection Guide

Use this guide to quickly choose the right template for your SEO analysis needs.

---

## 📊 Performance Templates

### Content Performance Deep Dive
**When to use**: Analyzing blog posts, articles, or content pages  
**Key metrics**: Clicks, CTR, Sessions, Conversions  
**Best for**: Content marketers, content strategists  
**Output**: Content gaps, optimization priorities, keyword diversity analysis

**Typical Questions Answered**:
- Which content performs best?
- What keywords are driving traffic to each piece?
- Where are conversion opportunities?
- Which content needs refreshing?

---

### Conversion Path Analysis  
**When to use**: Tracking how organic search leads to conversions  
**Key metrics**: Conversions, Bounce Rate, Session Duration  
**Best for**: CRO specialists, marketing managers  
**Output**: Landing page performance, device attribution, funnel analysis

**Typical Questions Answered**:
- Which landing pages convert best from organic?
- How do mobile users convert vs desktop?
- Where do users drop off?
- What's the path from search to conversion?

---

### Executive SEO Summary
**When to use**: Monthly stakeholder reports, quarterly reviews  
**Key metrics**: All major KPIs, business impact  
**Best for**: Executives, department heads, clients  
**Output**: High-level trends, ROI metrics, strategic priorities

**Typical Questions Answered**:
- How is organic search performing overall?
- What's the ROI of SEO efforts?
- What are the key wins and challenges?
- Where should we invest next?

---

## 🔧 Technical Templates

### Technical SEO Health Check
**When to use**: Monthly technical audits, site migrations, speed issues  
**Key metrics**: Core Web Vitals (LCP, FID, CLS), Mobile Usability  
**Best for**: Technical SEOs, developers  
**Output**: CWV performance, mobile gaps, technical fixes needed

**Typical Questions Answered**:
- Are Core Web Vitals passing?
- What's causing speed issues?
- How does mobile compare to desktop?
- What technical issues need fixing?

---

### Mobile SEO Performance  
**When to use**: Mobile-first indexing reviews, responsive design audits  
**Key metrics**: Mobile traffic, Mobile CWV, Mobile usability  
**Best for**: Mobile developers, UX designers  
**Output**: Mobile vs desktop gaps, usability issues, speed optimizations

**Typical Questions Answered**:
- How does mobile perform vs desktop?
- Are there mobile-specific ranking issues?
- What mobile UX issues exist?
- Is the site truly mobile-friendly?

---

## 🎯 Keyword & Visibility Templates

### Keyword Rankings & Opportunities
**When to use**: Keyword strategy planning, monthly SEO reviews  
**Key metrics**: Position, Query Impressions, Quick Wins (pos 11-20)  
**Best for**: SEO specialists, content strategists  
**Output**: Ranking trends, quick win opportunities, keyword cannibalization

**Typical Questions Answered**:
- Which keywords are trending up/down?
- What are "quick win" opportunities?
- Is there keyword cannibalization?
- What new keywords should we target?

---

### Competitive Visibility Analysis
**When to use**: Competitive research, market share analysis  
**Key metrics**: Impressions, Share of Voice, Position Distribution  
**Best for**: SEO managers, competitive analysts  
**Output**: Visibility trends, competitive gaps, topic opportunities

**Typical Questions Answered**:
- How visible are we in search?
- What topics do competitors own?
- Where are visibility gaps?
- What queries have high impressions but low CTR?

---

## ✨ Content & Rich Results Templates

### Rich Results Performance
**When to use**: Schema implementation reviews, SERP feature tracking  
**Key metrics**: Rich Result Impressions, Rich Result CTR  
**Best for**: Technical SEOs, structured data specialists  
**Output**: Current rich results, schema opportunities, CTR impact

**Typical Questions Answered**:
- What rich results do we have?
- How do rich results impact CTR?
- What schema should we add?
- Are rich results showing correctly?

---

### Content Refresh ROI
**When to use**: After content updates, content refresh campaigns  
**Key metrics**: Before/after metrics, time to impact  
**Best for**: Content marketers tracking update impact  
**Output**: Performance changes, ROI calculation, refresh recommendations

**Typical Questions Answered**:
- Did the content refresh work?
- How long did it take to see results?
- What's the ROI of content updates?
- Which pages should we refresh next?

---

## 📍 Local & Specialized Templates

### Local SEO Dashboard
**When to use**: Local business SEO, multi-location tracking  
**Key metrics**: Local pack visibility, Maps views, Direction requests  
**Best for**: Local businesses, franchise SEOs  
**Output**: Local visibility, top local queries, GMB performance

**Typical Questions Answered**:
- How visible are we in local search?
- What local queries drive traffic?
- How do different locations perform?
- Is our GMB optimized?

---

## Template Comparison Matrix

| Template | Complexity | Data Required | Time to Setup | Best For |
|----------|-----------|--------------|---------------|----------|
| Content Performance | Medium | GSC + GA4 | 5 min | Regular monitoring |
| Technical Health | High | GSC + GA4 + CWV | 10 min | Monthly audits |
| Keyword Rankings | Medium | GSC | 5 min | Weekly tracking |
| Conversion Path | Medium | GA4 | 5 min | Conversion optimization |
| Competitive Visibility | Medium | GSC | 5 min | Market analysis |
| Rich Results | Low | GSC | 3 min | Schema tracking |
| Content Refresh ROI | Low | GSC + GA4 | 3 min | Post-update analysis |
| Mobile SEO | High | GSC + GA4 | 10 min | Mobile optimization |
| Local SEO | Medium | GSC + GMB | 5 min | Local businesses |
| Executive Summary | Low | GSC + GA4 | 5 min | Stakeholder reports |

---

## Template Workflow Examples

### Workflow 1: Monthly Content Review
1. **Use Template**: Content Performance Deep Dive
2. **Add URLs**: All blog posts from last 90 days
3. **Date Range**: Last 30 days vs previous 30 days
4. **Review**: Top performers, content gaps, keyword diversity
5. **Action**: Plan new content based on gaps, optimize underperformers

### Workflow 2: Quarterly Executive Report  
1. **Use Template**: Executive SEO Summary
2. **Add URLs**: Top 20 landing pages
3. **Date Range**: Last quarter
4. **Review**: Overall trends, KPIs, business impact
5. **Action**: Present to stakeholders, adjust strategy

### Workflow 3: Post-Update Tracking
1. **Use Template**: Content Refresh ROI
2. **Add URLs**: Recently updated pages only
3. **Date Range**: 2 weeks before update to 4 weeks after
4. **Review**: Before/after metrics, time to impact
5. **Action**: Document what worked, apply to other pages

### Workflow 4: Technical Debt Sprint
1. **Use Template**: Technical SEO Health Check
2. **Add URLs**: All high-traffic pages
3. **Date Range**: Last 30 days
4. **Review**: CWV issues, mobile problems, crawl errors
5. **Action**: Create dev tickets, prioritize by impact

---

## Metrics Explained by Template

### Content Performance Deep Dive Metrics:
- **Clicks**: Direct traffic from search results
- **Impressions**: How often content appeared in search
- **CTR**: Click-through rate (clicks/impressions)
- **Sessions**: GA4 session count
- **Query Diversity**: Number of unique queries
- **Keyword Clouds**: Visual representation of query terms

### Technical Health Check Metrics:
- **LCP**: Largest Contentful Paint (loading performance)
- **FID**: First Input Delay (interactivity)
- **CLS**: Cumulative Layout Shift (visual stability)
- **Mobile Usability Issues**: GSC mobile usability errors
- **Index Coverage**: Pages indexed vs submitted

### Keyword Rankings & Opportunities Metrics:
- **Average Position**: Mean ranking position
- **Position Distribution**: Count of keywords by position range
- **Quick Wins**: Keywords in positions 11-20
- **Cannibalization Score**: Multiple pages competing for same query
- **Trending Keywords**: Queries with biggest position changes

### Rich Results Performance Metrics:
- **Rich Result Types**: Types detected (FAQ, Recipe, etc.)
- **Rich Result CTR**: CTR for rich vs standard results
- **Coverage %**: Percent of URLs with rich results
- **Schema Validation**: Structured data errors/warnings

---

## Advanced Tips

### Combining Templates
You can run multiple templates on the same URL set to get comprehensive insights:

**Example Combo 1: Full Content Audit**
1. Content Performance Deep Dive
2. Keyword Rankings & Opportunities  
3. Rich Results Performance

**Example Combo 2: Technical + Business Impact**
1. Technical SEO Health Check
2. Executive SEO Summary

**Example Combo 3: Conversion Optimization**
1. Conversion Path Analysis
2. Mobile SEO Performance
3. Content Performance Deep Dive

### Custom Date Ranges by Template

**Short-term (7-14 days)**:
- Content Refresh ROI (immediate impact)
- Technical Health Check (recent issues)

**Medium-term (30-60 days)**:
- Content Performance Deep Dive
- Keyword Rankings & Opportunities
- Mobile SEO Performance

**Long-term (90+ days)**:
- Executive Summary
- Competitive Visibility
- Local SEO Dashboard

### URL Selection Best Practices

**For Content Templates**:
- Include all content from same category
- Group by content type (blog, guides, landing pages)

**For Technical Templates**:
- Focus on high-traffic pages first
- Include template pages representing site sections

**For Keyword Templates**:
- Group pages targeting similar keyword clusters
- Include both high and low performers for comparison

**For Executive Templates**:
- Top 20-50 pages by traffic
- Representative sample across site sections

---

## Recommendation Types by Template

### Critical Recommendations (Red)
- **Technical Health**: Failing CWV, severe mobile issues
- **Keyword Rankings**: Dramatic position drops
- **Content Performance**: Very low CTR (<1%)

### Important Recommendations (Orange)
- **Technical Health**: Minor CWV issues, crawl errors
- **Keyword Rankings**: Position 11-20 (quick wins)
- **Rich Results**: Missing schema on high-traffic pages

### Opportunity Recommendations (Blue)
- **Content Performance**: Content gap opportunities
- **Keyword Rankings**: New keyword targeting ideas
- **Rich Results**: Schema types to add

---

## ROI by Template Type

### High ROI Templates (Quick Wins):
1. **Keyword Rankings & Opportunities** - Find position 11-20 keywords for easy wins
2. **Content Refresh ROI** - Identify which refreshes work best
3. **Rich Results Performance** - Quick schema implementations

### Medium ROI Templates (Strategic):
4. **Content Performance Deep Dive** - Long-term content strategy
5. **Mobile SEO Performance** - Mobile optimization projects
6. **Conversion Path Analysis** - Landing page optimization

### Foundation Templates (Essential):
7. **Technical SEO Health Check** - Prevent issues from growing
8. **Executive SEO Summary** - Secure buy-in and resources
9. **Competitive Visibility** - Stay ahead of competition
10. **Local SEO Dashboard** - Essential for local businesses

---

## Frequently Asked Questions

**Q: Can I modify a template?**  
A: Currently templates are pre-configured, but you can use the data and apply custom filters after generation.

**Q: How often should I run each template?**  
A: 
- Weekly: Keyword Rankings, Content Performance
- Monthly: Technical Health, Mobile SEO, Rich Results
- Quarterly: Executive Summary, Competitive Visibility
- As-needed: Content Refresh ROI, Local SEO

**Q: What if I don't have GA4 connected?**  
A: Templates requiring GA4 will still work with GSC-only data, but some metrics will be unavailable.

**Q: Can I compare two templates side-by-side?**  
A: Yes, generate both and export the data for comparison in Excel or your BI tool.

**Q: Which template is best for beginners?**  
A: Start with "Content Performance Deep Dive" - it's comprehensive but easy to understand.

---

## Template Changelog

### Version 2.0.0 (Current)
- Added 10 comprehensive templates
- Integrated AI recommendations
- Added keyword cloud generation
- Included CWV tracking
- Rich results detection

### Planned Updates (v2.1.0)
- Custom template builder
- Template sharing
- Historical comparison mode
- Automated scheduling
- Export to Google Slides
