# Visual UI Guide - Enhanced Performance Reports

## Main Interface Components

### 1. Header Section
```
┌─────────────────────────────────────────────────────────────────────┐
│ Generate Performance Reports                    [🪄 Templates]      │
│ Track URL performance with publish dates        [📤 Import CSV]     │
│ and change details from GA4 & GSC              [📥 Export CSV]     │
└─────────────────────────────────────────────────────────────────────┘
```

### 2. Account Connection Panel
```
┌─────────────────────────────────────────────────────────────────────┐
│ 🔗 Connect Accounts (Scoped to this Report)                         │
├──────────────────────────────────┬──────────────────────────────────┤
│ Google Search Console            │ Google Analytics 4               │
│ [✓ Connected / ✗ Not Connected]  │ [✓ Connected / ✗ Not Connected] │
│                                   │                                  │
│ [🔗 Connect GSC] or              │ [🔗 Connect GA4] or             │
│ [Property: sc-domain:example.com] │ [Property: 123456789]           │
└──────────────────────────────────┴──────────────────────────────────┘
```

### 3. Date Range Selector
```
┌─────────────────────────────────────────────────────────────────────┐
│ 📅 Data Collection Timeframe                                        │
├─────────────────────┬─────────────────────┬─────────────────────────┤
│ Start Date          │ End Date            │                         │
│ [2026-01-01▼]      │ [2026-01-29▼]      │ [📈 Fetch Data]        │
└─────────────────────┴─────────────────────┴─────────────────────────┘
```

### 4. URL Tracking Table
```
┌────────────────────────────────────────────────────────────────────────────────┐
│ URLs & Changes                                                    [➕ Add Row]  │
├──────────────────────────┬────────────┬─────────────┬──────┬──────┬────┬──────┤
│ URL                      │ Publish    │ Details     │ Clicks│ Impr.│Sess│ [🗑] │
│                          │ Date       │ of Change   │       │      │    │      │
├──────────────────────────┼────────────┼─────────────┼──────┼──────┼────┼──────┤
│ [https://example.com/p1] │ [2026-01-15]│ [Updated..] │ 1,234│ 5,678│ 890│ [🗑] │
│ [https://example.com/p2] │ [2026-01-20]│ [New post.] │   456│ 2,345│ 321│ [🗑] │
│ [                       ] │ [         ]│ [         ] │      │      │    │ [🗑] │
└──────────────────────────┴────────────┴─────────────┴──────┴──────┴────┴──────┘
```

### 5. Performance Charts Section
```
┌─────────────────────────────────────────────────────────────────────┐
│ 📊 Performance Charts                   [Chart Type: Bar Chart ▼]  │
├─────────────────────────────────────────────────────────────────────┤
│                                                                      │
│         [████████████ Chart Visualization Here █████████████]       │
│                                                                      │
│         Interactive Bar/Line/Pie Chart with Chart.js                │
│                                                                      │
├────────────┬────────────┬────────────┬────────────────────────────┤
│ 📈 Clicks  │ 👁 Impr.   │ 🔄 Sessions │ 📍 Avg CTR                 │
│  12,450    │  145,678   │   8,901    │  8.54%                     │
│  (Blue)    │  (Green)   │  (Orange)  │  (Purple)                  │
└────────────┴────────────┴────────────┴────────────────────────────┘
```

### 6. AI Insights Panel
```
┌─────────────────────────────────────────────────────────────────────┐
│ ✨ AI-Generated Insights                                            │
├─────────────────────────────────────────────────────────────────────┤
│                                                                      │
│ ## 📊 Performance Analysis                                          │
│                                                                      │
│ Between 2026-01-01 and 2026-01-29:                                 │
│ - **Total Clicks:** 12,450                                          │
│ - **Total Impressions:** 145,678                                    │
│ - **Average CTR:** 8.54%                                            │
│                                                                      │
│ ## 🎯 Top Performing Pages                                          │
│                                                                      │
│ 1. https://example.com/best-article                                 │
│    - Clicks: 3,200 | Impressions: 24,000 | CTR: 13.33%            │
│    - ✨ Rich Results: FAQ, Article                                  │
│    - ⚠️ CWV Issues: LCP: 3.2s                                       │
│                                                                      │
└─────────────────────────────────────────────────────────────────────┘
```

### 7. Recommendations Section
```
┌─────────────────────────────────────────────────────────────────────┐
│ 🎯 Actionable Recommendations                                       │
├─────────────────────────────────────────────────────────────────────┤
│ ┃ 🚨 FIX CORE WEB VITALS ISSUES              [CTR Optimization]    │
│ ┃ 3 pages have CWV issues affecting UX                             │
│ ┃ ✓ Optimize LCP by improving server response times                │
│ ┃ ✓ Reduce CLS by specifying image dimensions                      │
│ ┃ ✓ Use CDN and optimize images                                    │
│ ┃ ✓ Implement lazy loading for below-fold content                  │
├─────────────────────────────────────────────────────────────────────┤
│ │ ⚠️ IMPROVE SEARCH RANKINGS                [Rankings]             │
│ │ Most pages ranking beyond first page                             │
│ │ ✓ Conduct keyword gap analysis                                   │
│ │ ✓ Improve internal linking to target pages                       │
│ │ ✓ Enhance content depth and quality                              │
├─────────────────────────────────────────────────────────────────────┤
│ ┊ 💡 IMPLEMENT STRUCTURED DATA              [Rich Results]         │
│ ┊ 5 pages lack rich results                                        │
│ ┊ ✓ Add relevant schema markup (FAQ, Article, etc.)               │
│ ┊ ✓ Test with Google Rich Results Test                            │
│ ┊ ✓ Monitor rich result performance in GSC                        │
└─────────────────────────────────────────────────────────────────────┘

Color Key:
┃ Red border = Critical
│ Orange border = Important  
┊ Blue border = Opportunity
```

## Modal Screens

### Report Templates Modal
```
┌─────────────────────────────────────────────────────────────────────┐
│ Report Templates                                              [✕]   │
│ Choose a pre-configured template for your analysis                  │
├─────────────────────────────────────────────────────────────────────┤
│ [All] [Performance] [Technical] [Keywords] [Conversion] [More...]   │
├─────────────────────────────────────────────────────────────────────┤
│                                                                      │
│ ┌──────────────────────┐  ┌──────────────────────┐                 │
│ │ 📄 Content Deep Dive │  │ ⚙️ Technical Health   │                 │
│ │ Performance          │  │ Technical            │                 │
│ │                      │  │                      │                 │
│ │ Comprehensive        │  │ CWV, crawlability,   │                 │
│ │ content analysis...  │  │ and indexing...      │                 │
│ │                      │  │                      │                 │
│ │ Insights:            │  │ Insights:            │                 │
│ │ • Top content        │  │ • CWV performance    │                 │
│ │ • Content gaps       │  │ • Mobile gaps        │                 │
│ └──────────────────────┘  └──────────────────────┘                 │
│                                                                      │
│ ┌──────────────────────┐  ┌──────────────────────┐                 │
│ │ # Keyword Rankings   │  │ 📈 Conversion Path   │                 │
│ │ Keywords             │  │ Conversion           │                 │
│ │ ...                  │  │ ...                  │                 │
│ └──────────────────────┘  └──────────────────────┘                 │
│                                                                      │
├─────────────────────────────────────────────────────────────────────┤
│                                         [Close]                      │
└─────────────────────────────────────────────────────────────────────┘
```

### Property ID Configuration Modal
```
┌─────────────────────────────────────────────────────────────────────┐
│ Set GSC Property                                              [✕]   │
├─────────────────────────────────────────────────────────────────────┤
│                                                                      │
│ Site URL (e.g., sc-domain:example.com)                             │
│ ┌─────────────────────────────────────────────────────────────────┐│
│ │ sc-domain:example.com                                           ││
│ └─────────────────────────────────────────────────────────────────┘│
│                                                                      │
├─────────────────────────────────────────────────────────────────────┤
│                                  [Save]           [Cancel]           │
└─────────────────────────────────────────────────────────────────────┘
```

### Data Fetch Confirmation Modal
```
┌─────────────────────────────────────────────────────────────────────┐
│ Confirm Data Fetch                                            [✕]   │
├─────────────────────────────────────────────────────────────────────┤
│                                                                      │
│ You are about to fetch performance data for 3 URL(s)               │
│                                                                      │
│ ┌─────────────────────────────────────────────────────────────────┐│
│ │ • https://example.com/page-1                                    ││
│ │ • https://example.com/page-2                                    ││
│ │ • https://example.com/page-3                                    ││
│ └─────────────────────────────────────────────────────────────────┘│
│                                                                      │
│ Date range: 2026-01-01 to 2026-01-29                               │
│                                                                      │
│ ⚠️ This will fetch comprehensive data including clicks,             │
│    impressions, CWV, queries, and rich results.                    │
│                                                                      │
├─────────────────────────────────────────────────────────────────────┤
│                     [Confirm & Fetch]           [Cancel]             │
└─────────────────────────────────────────────────────────────────────┘
```

## Chart Types Visual Reference

### 1. Bar Chart - Traffic
```
  Clicks   Sessions
   ████     ████
   ████     ████
   ████     ████
   ████     ████
   ████     ██
    
  Page1   Page2   Page3
```

### 2. Line Chart - CTR Performance
```
CTR %
 20 |                    ●
    |              ●          ●
 10 |        ●
    |   ●
  0 |_________________________
    Page1 Page2 Page3 Page4 Page5
```

### 3. Position Rankings (Inverted)
```
Position
  1 |  ████
    |
  5 |     ████
    |
 10 |          ████
    |___________________
     Page1  Page2  Page3
```

### 4. Pie Chart - Distribution
```
        Page1 (40%)
      ╱────────────╲
     │              │
     │  Page2 (30%) │
     │              │
      ╲────────────╱
        Page3 (30%)
```

### 5. Core Web Vitals
```
  LCP (sec)  FID (ms)  CLS (×100)
   ████       ██        ██
   ████       ██        ██
   ████       ██        ██
```

## Keyword Cloud Visualization

### Sample Word Cloud Layout
```
                 guide           seo
        tips             tutorial        best
    how-to                                 strategies
              optimization      content
        marketing                      performance
    analytics        keywords
                           ranking
              traffic
```

**Visual Characteristics**:
- **Size**: Proportional to clicks + impressions
- **Color**: Viridis colormap (purple → blue → green → yellow)
- **Background**: Dark (#0f172a) matching UI
- **Layout**: Intelligent word placement avoiding overlaps
- **Font**: Sans-serif, readable at all sizes

## Color Scheme Reference

### Performance Metrics Cards
```
┌─────────────┐ ┌─────────────┐ ┌─────────────┐ ┌─────────────┐
│ 📈 Clicks   │ │ 👁 Impr.    │ │ 🔄 Sessions │ │ 📍 CTR      │
│ Blue        │ │ Green       │ │ Orange      │ │ Purple      │
│ #3B82F6     │ │ #10B981     │ │ #FB9232     │ │ #A855F7     │
└─────────────┘ └─────────────┘ └─────────────┘ └─────────────┘
```

### Recommendation Priority Colors
```
Critical:   🚨 Red Border     #EF4444
Important:  ⚠️  Orange Border  #F59E0B  
Opportunity: 💡 Blue Border    #3B82F6
```

### Status Indicators
```
Connected:     ✓ Green  #10B981
Not Connected: ✗ Gray   #6B7280
Loading:       ⟳ Blue   #3B82F6
Error:         ⚠ Red    #EF4444
```

## Interactive Elements

### Buttons
```
Primary Action:
┌─────────────────────────┐
│ 🔗 Connect GSC          │  ← Hover: Lighter blue
│ Blue bg, White text     │     Click: Slight scale
└─────────────────────────┘

Secondary Action:
┌─────────────────────────┐
│ 📤 Import CSV           │  ← Hover: Subtle glow
│ Dark bg, Border, White  │     Click: Border glow
└─────────────────────────┘

Danger Action:
┌─────────────────────────┐
│ 🗑 Delete               │  ← Hover: Red background
│ Transparent, Red icon   │     Click: Confirm modal
└─────────────────────────┘
```

### Dropdowns
```
Before Click:
┌──────────────────────┐
│ Chart Type: Bar ▼    │
└──────────────────────┘

After Click:
┌──────────────────────┐
│ Chart Type: Bar ▼    │
├──────────────────────┤
│ Bar Chart - Traffic  │ ← Hover: Highlight
│ CTR Performance      │
│ Position Rankings    │
│ Pie Chart            │
│ Core Web Vitals      │
└──────────────────────┘
```

### Table Rows
```
Normal State:
│ https://example.com/page │ 2026-01-15 │ Updated... │ 1,234 │

Hover State:
│ https://example.com/page │ 2026-01-15 │ Updated... │ 1,234 │
└─ Subtle background highlight, smooth transition
```

## Responsive Behavior

### Desktop (> 1024px)
```
┌──────────────────────────────────────────────────┐
│ [Header]────────────────────[Actions────────]    │
│                                                   │
│ [GSC Connection──────] [GA4 Connection──────]    │
│                                                   │
│ [Date Range──][Date Range──][Fetch Button───]    │
│                                                   │
│ [URL Table (Full Width)────────────────────]     │
│                                                   │
│ [Charts (Full Width)───────────────────────]     │
└──────────────────────────────────────────────────┘
```

### Tablet (768px - 1024px)
```
┌────────────────────────────────┐
│ [Header]──────[Actions↓]       │
│                                 │
│ [GSC Connection────────]        │
│ [GA4 Connection────────]        │
│                                 │
│ [Date──] [Date──] [Fetch]      │
│                                 │
│ [URL Table (Scrollable X)]     │
│                                 │
│ [Charts (Full Width)────]      │
└────────────────────────────────┘
```

### Mobile (< 768px)
```
┌──────────────────┐
│ [Header]         │
│ [Actions Stack↓] │
│                  │
│ [GSC Conn────]   │
│ [GA4 Conn────]   │
│                  │
│ [Start Date]     │
│ [End Date]       │
│ [Fetch Button]   │
│                  │
│ [URL Table]      │
│ (Scroll X + Y)   │
│                  │
│ [Charts Stack↓]  │
└──────────────────┘
```

## Loading States

### Data Fetching
```
┌─────────────────────────────────────────────┐
│ 📈 Fetch Performance Data                   │
│                                              │
│     ⟳ Loading Data...                       │
│                                              │
│     [████████████░░░░░░░░░░░] 60%          │
│                                              │
│     Fetching from GSC... ✓                  │
│     Fetching from GA4... ⟳                  │
│     Generating insights...                  │
└─────────────────────────────────────────────┘
```

### Chart Rendering
```
┌─────────────────────────────────────────────┐
│ 📊 Performance Charts                       │
│                                              │
│         [⟳ Rendering chart...]              │
│                                              │
│     Preparing data... ✓                     │
│     Drawing axes... ✓                       │
│     Plotting points... ⟳                    │
└─────────────────────────────────────────────┘
```

## Error States

### Connection Error
```
┌─────────────────────────────────────────────┐
│ Google Search Console                       │
│ ✗ Not Connected                             │
│                                              │
│ ⚠️ Connection failed                        │
│ Error: Invalid OAuth credentials            │
│                                              │
│ [🔄 Retry Connection]                       │
└─────────────────────────────────────────────┘
```

### Data Fetch Error
```
┌─────────────────────────────────────────────┐
│ ⚠️ Error fetching data                      │
│                                              │
│ GSC Error: Invalid property URL             │
│                                              │
│ Please check:                                │
│ • Property URL is correct                   │
│ • Account has access to property            │
│ • OAuth token is valid                      │
│                                              │
│ [Retry] [Edit Property]                     │
└─────────────────────────────────────────────┘
```

## Success States

### Connection Success
```
┌─────────────────────────────────────────────┐
│ Google Search Console                       │
│ ✓ Connected                                 │
│                                              │
│ ✨ Successfully connected!                  │
│ Property: sc-domain:example.com             │
│                                              │
│ [Change Property]                           │
└─────────────────────────────────────────────┘
```

### Data Fetch Success
```
┌─────────────────────────────────────────────┐
│ ✓ Data fetched successfully!                │
│                                              │
│ • 5 URLs analyzed                            │
│ • 250 queries collected                      │
│ • 5 keyword clouds generated                 │
│ • 8 recommendations created                  │
│                                              │
│ [View Results ↓]                            │
└─────────────────────────────────────────────┘
```

## Animation Details

### Smooth Transitions
```
Button Hover:
  Duration: 150ms
  Property: background-color, transform
  Easing: ease-in-out

Modal Open/Close:
  Duration: 200ms
  Property: opacity, transform
  Easing: cubic-bezier(0.4, 0, 0.2, 1)

Chart Render:
  Duration: 500ms
  Property: opacity, scale
  Easing: ease-out

Loading Spinner:
  Animation: rotate
  Duration: 1s
  Iteration: infinite
  Easing: linear
```

This visual guide provides a comprehensive reference for understanding the UI layout, interactive elements, and visual feedback throughout the Enhanced Performance Reports feature.
