# Apache VirtualHost Configuration Snippet

Add this configuration block inside the `<VirtualHost>` tags in BOTH:
- `/etc/apache2/sites-available/code.jetlifecdn.com.conf`
- `/etc/apache2/sites-available/code.jetlifecdn.com-le-ssl.conf`

## Configuration Block

```apache
    # ============================================================
    # SMS XML Search & Bookmarking Tool
    # Application Path: /xml-tools/sms/
    # Backend API: http://127.0.0.1:3000
    # ============================================================

    # Static file serving and SPA routing
    <Directory /mnt/media_drive2/site-root/code.jetlifecdn.com/xml-tools/sms>
        Options -Indexes +FollowSymLinks
        AllowOverride All
        Require all granted
        
        # Enable SPA routing - rewrite all non-file/directory requests to index.html
        <IfModule mod_rewrite.c>
            RewriteEngine On
            RewriteBase /xml-tools/sms/
            
            # Exclude API calls from SPA rewrite
            RewriteCond %{REQUEST_URI} ^/xml-tools/sms/api/ [OR]
            
            # Exclude actual files and directories
            RewriteCond %{REQUEST_FILENAME} -f [OR]
            RewriteCond %{REQUEST_FILENAME} -d
            
            # Negate the last two conditions
            RewriteCond %{REQUEST_FILENAME} !-f
            RewriteCond %{REQUEST_FILENAME} !-d
            RewriteCond %{REQUEST_URI} !^/xml-tools/sms/api/
            
            # Rewrite everything else to index.html for React Router
            RewriteRule ^ /xml-tools/sms/index.html [L]
        </IfModule>
    </Directory>
    
    # API Reverse Proxy Configuration
    ProxyPreserveHost On
    ProxyPass /xml-tools/sms/api/ http://127.0.0.1:3000/ timeout=300 connectiontimeout=30
    ProxyPassReverse /xml-tools/sms/api/ http://127.0.0.1:3000/
    
    # WebSocket Support for Real-time Progress Updates
    <IfModule mod_rewrite.c>
        RewriteEngine On
        
        # Route WebSocket connections to backend
        RewriteCond %{HTTP:Upgrade} websocket [NC]
        RewriteCond %{HTTP:Connection} upgrade [NC]
        RewriteRule ^/xml-tools/sms/api/(.*)$ "ws://127.0.0.1:3000/$1" [P,L]
    </IfModule>
    
    # Additional Proxy Headers
    <IfModule mod_proxy.c>
        ProxyRequests Off
        
        # Forward essential headers to backend
        ProxyAddHeaders On
        RequestHeader set X-Forwarded-Proto https
        RequestHeader set X-Forwarded-Host %{HTTP_HOST}e
        RequestHeader set X-Forwarded-For %{REMOTE_ADDR}e
        
        # Timeouts
        ProxyTimeout 300
    </IfModule>
```

## Required Apache Modules

Enable these modules using `a2enmod`:

```bash
sudo a2enmod proxy
sudo a2enmod proxy_http
sudo a2enmod proxy_wstunnel
sudo a2enmod rewrite
sudo a2enmod headers
```

Or in a single command:
```bash
sudo a2enmod proxy proxy_http proxy_wstunnel rewrite headers
```

## Configuration Validation

After making changes, test the syntax:

```bash
sudo apache2ctl configtest
# Should output: Syntax OK
```

If syntax is OK, reload Apache:

```bash
sudo systemctl reload apache2
```

## Verify Proxy is Working

Test the API endpoint:

```bash
# Health check
curl -v https://code.jetlifecdn.com/xml-tools/sms/api/health

# Should return JSON with status "ok"
```

## Troubleshooting

### 502 Bad Gateway
- Backend API not running: `sudo systemctl status sms-xml-backend`
- Backend logs: `tail -f /mnt/media_drive2/site-root/code.jetlifecdn.com/xml-tools/sms/logs/backend.log`
- Check connectivity: `curl http://127.0.0.1:3000/api/health`

### 404 on API calls
- Verify RewriteRule is not catching API paths
- Check Apache error log: `tail -50 /var/log/apache2/error.log`

### SPA Routes Not Working
- Verify RewriteEngine is On in Directory block
- Check RewriteBase is `/xml-tools/sms/`
- Ensure index.html exists in document root

### CORS Errors
- Frontend not at expected domain
- Check `CORS_ORIGIN` in backend `.env`
- Verify `X-Forwarded-*` headers are being set

## Notes

- Application serves frontend static files from: `/mnt/media_drive2/site-root/code.jetlifecdn.com/xml-tools/sms/`
- Backend API listens on: `127.0.0.1:3000` (loopback only - safer)
- WebSocket connections for progress updates: `/xml-tools/sms/api/ws/*`
- SSL/TLS is handled by Apache, backend serves plain HTTP on loopback
